/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.jline.builtins.ConfigurationPath;
import org.jline.console.CommandRegistry;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.widget.TailTipWidgets;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@CommandLine.Command(name="shell", description={"Interactive Camel JBang shell. Hit @|magenta <TAB>|@ to see available commands."}, footer={"Press Ctrl-C to exit."})
public class Shell
extends CamelCommand {
    public Shell(CamelJBangMain main) {
        super(main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer doCall() throws Exception {
        Supplier<Path> workDir = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
        Builtins builtins = new Builtins(workDir, new ConfigurationPath(workDir.get(), workDir.get()), null){

            public String name() {
                return "built-in";
            }
        };
        PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
        PicocliCommands commands = new PicocliCommands(CamelJBangMain.getCommandLine());
        commands.name("Camel");
        DefaultParser parser = new DefaultParser();
        try (Terminal terminal = TerminalBuilder.builder().build();){
            SystemRegistryImpl systemRegistry = new SystemRegistryImpl((Parser)parser, terminal, workDir, null);
            systemRegistry.setCommandRegistries(new CommandRegistry[]{builtins, commands});
            systemRegistry.register("help", (CommandRegistry)commands);
            LineReader reader = LineReaderBuilder.builder().terminal(terminal).completer(systemRegistry.completer()).parser((Parser)parser).variable("list-max", (Object)50).build();
            builtins.setLineReader(reader);
            factory.setTerminal(terminal);
            TailTipWidgets widgets = new TailTipWidgets(reader, arg_0 -> ((SystemRegistry)systemRegistry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
            widgets.enable();
            KeyMap keyMap = (KeyMap)reader.getKeyMaps().get("main");
            keyMap.bind((Object)new Reference("tailtip-toggle"), (CharSequence)KeyMap.alt((String)"s"));
            String prompt = "camel> ";
            String rightPrompt = null;
            boolean run = true;
            TerminalBuilder.setTerminalOverride((Terminal)terminal);
            while (run) {
                try {
                    systemRegistry.cleanUp();
                    String line = reader.readLine(prompt, rightPrompt, (MaskingCallback)null, null);
                    systemRegistry.execute(line);
                }
                catch (SystemRegistryImpl.UnknownCommandException unknownCommandException) {
                }
                catch (UserInterruptException e) {
                    run = false;
                }
                catch (EndOfFileException e) {
                    run = false;
                }
                catch (Exception e) {
                    systemRegistry.trace((Throwable)e);
                }
            }
        }
        finally {
            TerminalBuilder.setTerminalOverride(null);
        }
        return 0;
    }
}

