/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.FileUtils;

class ExportSpringBoot
extends Export {
    public ExportSpringBoot(CamelJBangMain main) {
        super(main);
        this.pomTemplateName = "spring-boot-pom.tmpl";
    }

    @Override
    public Integer export() throws Exception {
        String[] ids = this.gav.split(":");
        if (ids.length != 3) {
            this.printer().printErr("--gav must be in syntax: groupId:artifactId:version");
            return 1;
        }
        if (!this.buildTool.equals("maven") && !this.buildTool.equals("gradle")) {
            this.printer().printErr("--build-tool must either be maven or gradle, was: " + this.buildTool);
            return 1;
        }
        File profile = new File("application.properties");
        File settings = new File(CommandLineHelper.getWorkDir(), "camel-jbang-run.properties");
        if (this.fresh || !this.files.isEmpty() || !settings.exists()) {
            this.printer().println("Generating fresh run data");
            int silent = this.runSilently(this.ignoreLoadingError, this.lazyBean, this.verbose);
            if (silent != 0) {
                return silent;
            }
        } else {
            this.printer().println("Reusing existing run data");
        }
        this.printer().println("Exporting as Spring Boot project to: " + this.exportDir);
        File buildDir = new File(".camel-jbang/work");
        FileUtil.removeDir((File)buildDir);
        buildDir.mkdirs();
        File srcJavaDirRoot = new File(".camel-jbang/work", "src/main/java");
        String srcPackageName = this.exportPackageName(ids[0], ids[1], this.packageName);
        File srcJavaDir = srcPackageName == null ? srcJavaDirRoot : new File(srcJavaDirRoot, srcPackageName.replace('.', File.separatorChar));
        srcJavaDir.mkdirs();
        File srcResourcesDir = new File(".camel-jbang/work", "src/main/resources");
        srcResourcesDir.mkdirs();
        File srcCamelResourcesDir = new File(".camel-jbang/work", "src/main/resources/camel");
        File srcKameletsResourcesDir = new File(".camel-jbang/work", "src/main/resources/kamelets");
        this.copyApplicationPropertiesFiles(srcResourcesDir);
        this.copySourceFiles(settings, profile, srcJavaDirRoot, srcJavaDir, srcResourcesDir, srcCamelResourcesDir, srcKameletsResourcesDir, srcPackageName);
        this.createMainClassSource(srcJavaDir, srcPackageName, this.mainClassname);
        Set<String> deps = this.resolveDependencies(settings, profile);
        this.copyLocalLibDependencies(deps);
        this.copySettingsAndProfile(settings, profile, srcResourcesDir, prop -> {
            int port;
            boolean http;
            if (!ExportSpringBoot.hasModeline(settings)) {
                prop.remove("camel.main.modeline");
            }
            if (!(http = deps.stream().anyMatch(s -> s.contains("mvn:org.apache.camel:camel-platform-http")))) {
                prop.put("camel.springboot.main-run-controller", "true");
            }
            if ((port = ExportSpringBoot.httpServerPort(settings)) == -1 && http) {
                port = 8080;
            }
            if (port != -1 && port != 8080) {
                prop.put("server.port", (Object)port);
            }
            return prop;
        });
        if ("maven".equals(this.buildTool)) {
            this.createMavenPom(settings, profile, new File(".camel-jbang/work", "pom.xml"), deps);
            if (this.mavenWrapper) {
                this.copyMavenWrapper();
            }
        } else if ("gradle".equals(this.buildTool)) {
            this.createSettingsGradle(new File(".camel-jbang/work", "settings.gradle"));
            this.createBuildGradle(settings, new File(".camel-jbang/work", "build.gradle"), deps);
            if (this.gradleWrapper) {
                this.copyGradleWrapper();
            }
        }
        this.copyDockerFiles(".camel-jbang/work");
        String appJar = "target" + File.separator + ids[1] + "-" + ids[2] + ".jar";
        this.copyReadme(".camel-jbang/work", appJar);
        if (this.cleanExportDir || !this.exportDir.equals(".")) {
            CommandHelper.cleanExportDir(this.exportDir);
        }
        FileUtils.copyDirectory((File)new File(".camel-jbang/work"), (File)new File(this.exportDir));
        FileUtil.removeDir((File)new File(".camel-jbang/work"));
        return 0;
    }

    private void createSettingsGradle(File file) throws Exception {
        String[] ids = this.gav.split(":");
        String text = String.format("rootProject.name = '%s'", ids[1]);
        IOHelper.writeText((String)text, (OutputStream)new FileOutputStream(file, false));
    }

    private void createMavenPom(File settings, File profile, File pom, Set<String> deps) throws Exception {
        InputStream template;
        String[] ids = this.gav.split(":");
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.camelSpringBootVersion);
        CamelCatalog catalog = CatalogLoader.loadSpringBootCatalog(repos, this.camelSpringBootVersion);
        if (ObjectHelper.isEmpty((String)this.camelVersion)) {
            this.camelVersion = catalog.getLoadedVersion();
        }
        if (ObjectHelper.isEmpty((String)this.camelVersion)) {
            this.camelVersion = VersionHelper.extractCamelVersion();
        }
        String context = (template = catalog.loadResource("camel-jbang", this.pomTemplateName)) != null ? IOHelper.loadText((InputStream)template) : this.readResourceTemplate("templates/" + this.pomTemplateName);
        context = context.replaceAll("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceAll("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceAll("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.SpringBootVersion }}", this.springBootVersion);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        context = context.replaceAll("\\{\\{ \\.CamelSpringBootVersion }}", Objects.requireNonNullElseGet(this.camelSpringBootVersion, () -> this.camelVersion));
        context = context.replaceFirst("\\{\\{ \\.ProjectBuildOutputTimestamp }}", this.getBuildMavenProjectDate());
        context = this.replaceBuildProperties(context);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            String s = ExportSpringBoot.mavenRepositoriesAsPomXml(repos);
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", s);
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = ExportSpringBoot.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.springboot", aid + "-starter", null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(null);
                } else {
                    gav.setVersion(this.camelVersion);
                }
            }
            if ("org.springframework.boot".equals(gid)) {
                gav.setVersion(null);
            }
            gavs.add(gav);
        }
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            sb.append("        <dependency>\n");
            sb.append("            <groupId>").append(gav.getGroupId()).append("</groupId>\n");
            sb.append("            <artifactId>").append(gav.getArtifactId()).append("</artifactId>\n");
            if (gav.getVersion() != null) {
                sb.append("            <version>").append(gav.getVersion()).append("</version>\n");
            }
            if ("lib".equals(gav.getPackaging())) {
                sb.append("            <scope>system</scope>\n");
                sb.append("            <systemPath>\\$\\{project.basedir}/lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar</systemPath>\n");
            } else if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("            <exclusions>\n");
                sb.append("                <exclusion>\n");
                sb.append("                    <groupId>org.apache.camel</groupId>\n");
                sb.append("                    <artifactId>*</artifactId>\n");
                sb.append("                </exclusion>\n");
                sb.append("            </exclusions>\n");
            }
            sb.append("        </dependency>\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(pom, false));
    }

    private void createBuildGradle(File settings, File gradleBuild, Set<String> deps) throws Exception {
        String[] ids = this.gav.split(":");
        String context = this.readResourceTemplate("templates/spring-boot-build-gradle.tmpl");
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.camelSpringBootVersion);
        CamelCatalog catalog = CatalogLoader.loadSpringBootCatalog(repos, this.camelSpringBootVersion);
        String camelVersion = catalog.getLoadedVersion();
        context = context.replaceFirst("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceFirst("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceFirst("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.SpringBootVersion }}", this.springBootVersion);
        context = context.replaceFirst("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", camelVersion);
        context = context.replaceFirst("\\{\\{ \\.CamelSpringBootVersion }}", Objects.requireNonNullElse(this.camelSpringBootVersion, camelVersion));
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            StringBuilder sb = new StringBuilder();
            for (String repo : repos.split(",")) {
                sb.append("    maven {\n");
                sb.append("        url '").append(repo).append("'\n");
                if (repo.contains("snapshots")) {
                    sb.append("        mavenContent {\n");
                    sb.append("            snapshotsOnly()\n");
                    sb.append("        }\n");
                }
                sb.append("    }\n");
            }
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", sb.toString());
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = ExportSpringBoot.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.springboot", aid + "-starter", null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(am.getVersion());
                } else {
                    gav.setVersion(camelVersion);
                }
            }
            gavs.add(gav);
        }
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            if ("lib".equals(gav.getPackaging())) {
                sb.append("    implementation files('lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar')\n");
                continue;
            }
            if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("    implementation ('").append(gav).append("') {\n");
                sb.append("        exclude group: 'org.apache.camel', module: '*'\n");
                sb.append("    }\n");
                continue;
            }
            sb.append("    implementation '").append(gav).append("'\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(gradleBuild, false));
    }

    @Override
    protected Set<String> resolveDependencies(File settings, File profile) throws Exception {
        Set<String> answer = super.resolveDependencies(settings, profile);
        answer.removeIf(s -> s.contains("camel-core"));
        boolean http = answer.stream().anyMatch(s -> s.contains("mvn:org.apache.camel:camel-platform-http"));
        if (this.hasOpenapi(answer) && !http) {
            answer.add("mvn:org.apache.camel:camel-platform-http");
        }
        return answer;
    }

    private void createMainClassSource(File srcJavaDir, String packageName, String mainClassname) throws Exception {
        String context = this.readResourceTemplate("templates/spring-boot-main.tmpl");
        context = context.replaceFirst("\\{\\{ \\.PackageName }}", packageName);
        context = context.replaceAll("\\{\\{ \\.MainClassname }}", mainClassname);
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(String.valueOf(srcJavaDir) + "/" + mainClassname + ".java", false));
    }

    @Override
    protected void adjustJavaSourceFileLine(String line, FileOutputStream fos) throws Exception {
        if (line.startsWith("public class") && (line.contains("RouteBuilder") || line.contains("EndpointRouteBuilder"))) {
            fos.write("import org.springframework.stereotype.Component;\n\n".getBytes(StandardCharsets.UTF_8));
            fos.write("@Component\n".getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    protected String applicationPropertyLine(String key, String value) {
        boolean camel44orOlder;
        if (((String)key).startsWith("camel.server.")) {
            return null;
        }
        boolean bl = camel44orOlder = this.camelSpringBootVersion != null && VersionHelper.isLE("4.4", this.camelSpringBootVersion);
        if (camel44orOlder && ((String)key).startsWith("camel.main.")) {
            key = "camel.springboot." + ((String)key).substring(11);
        }
        return super.applicationPropertyLine((String)key, value);
    }

    private String readResourceTemplate(String name) throws IOException {
        InputStream is = ExportSpringBoot.class.getClassLoader().getResourceAsStream(name);
        String text = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        return text;
    }
}

