/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.common.CatalogLoader;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.io.FileUtils;

class ExportQuarkus
extends Export {
    public ExportQuarkus(CamelJBangMain main) {
        super(main);
        this.pomTemplateName = "quarkus-pom.tmpl";
    }

    @Override
    public Integer export() throws Exception {
        String[] ids = this.gav.split(":");
        if (ids.length != 3) {
            this.printer().printErr("--gav must be in syntax: groupId:artifactId:version");
            return 1;
        }
        if (!this.buildTool.equals("maven") && !this.buildTool.equals("gradle")) {
            this.printer().printErr("--build-tool must either be maven or gradle, was: " + this.buildTool);
            return 1;
        }
        File profile = new File("application.properties");
        File settings = new File(CommandLineHelper.getWorkDir(), "camel-jbang-run.properties");
        if (this.fresh || !this.files.isEmpty() || !settings.exists()) {
            this.printer().println("Generating fresh run data");
            int silent = this.runSilently(this.ignoreLoadingError, this.lazyBean, this.verbose);
            if (silent != 0) {
                return silent;
            }
        } else {
            this.printer().println("Reusing existing run data");
        }
        this.printer().println("Exporting as Quarkus project to: " + this.exportDir);
        File buildDir = new File(".camel-jbang/work");
        FileUtil.removeDir((File)buildDir);
        buildDir.mkdirs();
        File srcJavaDirRoot = new File(".camel-jbang/work", "src/main/java");
        String srcPackageName = this.exportPackageName(ids[0], ids[1], this.packageName);
        File srcJavaDir = srcPackageName == null ? srcJavaDirRoot : new File(srcJavaDirRoot, srcPackageName.replace('.', File.separatorChar));
        srcJavaDir.mkdirs();
        File srcResourcesDir = new File(".camel-jbang/work", "src/main/resources");
        srcResourcesDir.mkdirs();
        File srcCamelResourcesDir = new File(".camel-jbang/work", "src/main/resources/camel");
        File srcKameletsResourcesDir = new File(".camel-jbang/work", "src/main/resources/kamelets");
        this.copySourceFiles(settings, profile, srcJavaDirRoot, srcJavaDir, srcResourcesDir, srcCamelResourcesDir, srcKameletsResourcesDir, srcPackageName);
        this.copySettingsAndProfile(settings, profile, srcResourcesDir, prop -> {
            int port;
            if (!ExportQuarkus.hasModeline(settings)) {
                prop.remove("camel.main.modeline");
            }
            if ((port = ExportQuarkus.httpServerPort(settings)) == -1) {
                port = 8080;
            }
            if (port != -1 && port != 8080) {
                prop.put("quarkus.http.port", (Object)port);
            }
            return prop;
        });
        this.copyDockerFiles(".camel-jbang/work");
        String appJar = "target" + File.separator + "quarkus-app" + File.separator + "quarkus-run.jar";
        this.copyReadme(".camel-jbang/work", appJar);
        Set<String> deps = this.resolveDependencies(settings, profile);
        this.copyLocalLibDependencies(deps);
        if ("maven".equals(this.buildTool)) {
            this.createMavenPom(settings, new File(".camel-jbang/work", "pom.xml"), deps);
            if (this.mavenWrapper) {
                this.copyMavenWrapper();
            }
        } else if ("gradle".equals(this.buildTool)) {
            this.createGradleProperties(new File(".camel-jbang/work", "gradle.properties"));
            this.createSettingsGradle(new File(".camel-jbang/work", "settings.gradle"));
            this.createBuildGradle(settings, new File(".camel-jbang/work", "build.gradle"), deps);
            if (this.gradleWrapper) {
                this.copyGradleWrapper();
            }
        }
        if (this.cleanExportDir || !this.exportDir.equals(".")) {
            CommandHelper.cleanExportDir(this.exportDir);
        }
        FileUtils.copyDirectory((File)new File(".camel-jbang/work"), (File)new File(this.exportDir));
        FileUtil.removeDir((File)new File(".camel-jbang/work"));
        return 0;
    }

    @Override
    protected void prepareApplicationProperties(Properties properties) {
        String extra;
        super.prepareApplicationProperties(properties);
        StringJoiner sj = new StringJoiner(",");
        StringJoiner sj2 = new StringJoiner(",");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            if ("camel.main.routesIncludePattern".equals(k)) {
                v = Arrays.stream(v.split(",")).filter(d -> !d.endsWith(".java")).map(ExportQuarkus::removeScheme).map(s -> {
                    if (s.endsWith("kamelet.yaml")) {
                        return "kamelets/" + s;
                    }
                    return "camel/" + s;
                }).collect(Collectors.joining(","));
                sj.add(v);
            }
            if (!"camel.jbang.classpathFiles".equals(k)) continue;
            v = Arrays.stream(v.split(",")).filter(d -> !d.endsWith(".jar")).map(ExportQuarkus::removeScheme).collect(Collectors.joining(","));
            sj2.add(v);
        }
        String routes = sj.length() > 0 ? sj.toString() : null;
        String string = extra = sj2.length() > 0 ? sj2.toString() : null;
        if (routes != null || extra != null) {
            sj = new StringJoiner(",");
            String e = properties.getProperty("quarkus.native.resources.includes");
            if (e != null) {
                sj.add(e);
            }
            if (routes != null) {
                sj.add(routes);
            }
            if (extra != null) {
                sj.add(extra);
            }
            if (sj.length() > 0) {
                properties.setProperty("quarkus.native.resources.includes", sj.toString());
            }
            if (routes != null) {
                properties.setProperty("camel.main.routes-include-pattern", routes);
            }
        }
        if (VersionHelper.isBetween(this.quarkusVersion, "3.11", "3.13") && !properties.containsKey("quarkus.camel.openapi.codegen.model-package")) {
            properties.put("quarkus.camel.openapi.codegen.model-package", "org.apache.camel.quarkus");
        }
    }

    private static String removeScheme(String s) {
        if (s.contains(":")) {
            s = StringHelper.after((String)s, (String)":");
        }
        if (s.contains(File.separator)) {
            s = StringHelper.afterLast((String)s, (String)File.separator);
        }
        s = s.replace(".camel-jbang/", "");
        return s;
    }

    private void createGradleProperties(File output) throws Exception {
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/quarkus-gradle-properties.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceFirst("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceFirst("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(output, false));
    }

    private void createSettingsGradle(File output) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/quarkus-settings-gradle.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = context.replaceFirst("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceFirst("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceFirst("\\{\\{ \\.Version }}", ids[2]);
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(output, false));
    }

    private void createBuildGradle(File settings, File gradleBuild, Set<String> deps) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportSpringBoot.class.getClassLoader().getResourceAsStream("templates/quarkus-build-gradle.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.quarkusVersion);
        CamelCatalog catalog = CatalogLoader.loadQuarkusCatalog(repos, this.quarkusVersion, this.quarkusGroupId);
        if (this.camelVersion == null) {
            this.camelVersion = catalog.getCatalogVersion();
        }
        context = context.replaceFirst("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceFirst("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceFirst("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceFirst("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceFirst("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            StringBuilder sb = new StringBuilder();
            for (String repo : repos.split(",")) {
                sb.append("    maven {\n");
                sb.append("        url '").append(repo).append("'\n");
                if (repo.contains("snapshots")) {
                    sb.append("        mavenContent {\n");
                    sb.append("            snapshotsOnly()\n");
                    sb.append("        }\n");
                }
                sb.append("    }\n");
            }
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", sb.toString());
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = ExportQuarkus.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                String qaid = aid.replace("camel-", "camel-quarkus-");
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.quarkus", qaid, null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(null);
                } else {
                    gav.setVersion(this.camelVersion);
                }
            }
            gavs.add(gav);
        }
        this.replaceQuarkusDependencies(gavs);
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            if ("lib".equals(gav.getPackaging())) {
                sb.append("    implementation files('lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar')\n");
                continue;
            }
            if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("    implementation ('").append(gav).append("') {\n");
                sb.append("        exclude group: 'org.apache.camel', module: '*'\n");
                sb.append("    }\n");
                continue;
            }
            sb.append("    implementation '").append(gav).append("'\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(gradleBuild, false));
    }

    private void replaceQuarkusDependencies(List<MavenGav> gavs) {
        HashMap<MavenGav, MavenGav> replace = new HashMap<MavenGav, MavenGav>();
        try {
            InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-dependencies.properties");
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                for (String k : prop.stringPropertyNames()) {
                    String v = prop.getProperty(k);
                    MavenGav from = ExportQuarkus.parseMavenGav(k);
                    MavenGav to = ExportQuarkus.parseMavenGav(v);
                    if (from == null || to == null) continue;
                    replace.put(from, to);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (MavenGav gav : gavs) {
            replace.keySet().stream().filter(q -> ExportQuarkus.compareGav(q, gav)).findFirst().ifPresent(q -> {
                MavenGav to = (MavenGav)replace.get(q);
                gav.setGroupId(to.getGroupId());
                gav.setArtifactId(to.getArtifactId());
                gav.setVersion(to.getVersion());
            });
        }
    }

    @Override
    protected String applicationPropertyLine(String key, String value) {
        if (key.startsWith("camel.server.")) {
            return null;
        }
        if (key.startsWith("quarkus.") || key.startsWith("camel.")) {
            key = StringHelper.camelCaseToDash((String)key);
        }
        return super.applicationPropertyLine(key, value);
    }

    @Override
    protected void copyDockerFiles(String buildDir) throws Exception {
        File docker = new File(buildDir, "src/main/docker");
        docker.mkdirs();
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.jvm");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(docker, "Dockerfile.jvm")));
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.jvm");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(docker, "Dockerfile")));
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.legacy-jar");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(docker, "Dockerfile.legacy-jar")));
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.native");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(docker, "Dockerfile.native")));
        is = ExportQuarkus.class.getClassLoader().getResourceAsStream("quarkus-docker/Dockerfile.native-micro");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(docker, "Dockerfile.native-micro")));
    }

    private void createMavenPom(File settings, File pom, Set<String> deps) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportQuarkus.class.getClassLoader().getResourceAsStream("templates/" + this.pomTemplateName);
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.quarkusVersion);
        CamelCatalog catalog = CatalogLoader.loadQuarkusCatalog(repos, this.quarkusVersion, this.quarkusGroupId);
        if (this.camelVersion == null) {
            this.camelVersion = catalog.getCatalogVersion();
        }
        context = context.replaceAll("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceAll("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceAll("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.QuarkusGroupId }}", this.quarkusGroupId);
        context = context.replaceAll("\\{\\{ \\.QuarkusArtifactId }}", this.quarkusArtifactId);
        context = context.replaceAll("\\{\\{ \\.QuarkusVersion }}", this.quarkusVersion);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        context = context.replaceAll("\\{\\{ \\.ProjectBuildOutputTimestamp }}", this.getBuildMavenProjectDate());
        context = this.replaceBuildProperties(context);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            String s = ExportQuarkus.mavenRepositoriesAsPomXml(repos);
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", s);
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = ExportQuarkus.parseMavenGav(dep);
            String gid = gav.getGroupId();
            String aid = gav.getArtifactId();
            if ("org.apache.camel".equals(gid)) {
                String qaid = aid.replace("camel-", "camel-quarkus-");
                ArtifactModel am = catalog.modelFromMavenGAV("org.apache.camel.quarkus", qaid, null);
                if (am != null) {
                    gav.setGroupId(am.getGroupId());
                    gav.setArtifactId(am.getArtifactId());
                    gav.setVersion(null);
                } else {
                    gav.setVersion(this.camelVersion);
                }
            }
            gavs.add(gav);
        }
        this.replaceQuarkusDependencies(gavs);
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            if ("camel-quarkus-core".equals(gav.getArtifactId()) || "camel-quarkus-microprofile-health".equals(gav.getArtifactId())) continue;
            sb.append("        <dependency>\n");
            sb.append("            <groupId>").append(gav.getGroupId()).append("</groupId>\n");
            sb.append("            <artifactId>").append(gav.getArtifactId()).append("</artifactId>\n");
            if (gav.getVersion() != null) {
                sb.append("            <version>").append(gav.getVersion()).append("</version>\n");
            }
            if ("lib".equals(gav.getPackaging())) {
                sb.append("            <scope>system</scope>\n");
                sb.append("            <systemPath>\\$\\{project.basedir}/lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar</systemPath>\n");
            } else if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("            <exclusions>\n");
                sb.append("                <exclusion>\n");
                sb.append("                    <groupId>org.apache.camel</groupId>\n");
                sb.append("                    <artifactId>*</artifactId>\n");
                sb.append("                </exclusion>\n");
                sb.append("            </exclusions>\n");
            }
            sb.append("        </dependency>\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(pom, false));
    }

    @Override
    protected Set<String> resolveDependencies(File settings, File profile) throws Exception {
        Set<String> answer = super.resolveDependencies(settings, profile);
        answer.removeIf(s -> s.contains("camel-core"));
        answer.removeIf(s -> s.contains("camel-microprofile-health"));
        return answer;
    }

    private static boolean compareGav(MavenGav g1, MavenGav g2) {
        return g1.getGroupId().equals(g2.getGroupId()) && g1.getArtifactId().equals(g2.getArtifactId());
    }
}

