/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.common.CommandLineHelper;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.FileUtils;

class ExportCamelMain
extends Export {
    public ExportCamelMain(CamelJBangMain main) {
        super(main);
        this.pomTemplateName = "main-pom.tmpl";
    }

    @Override
    public Integer export() throws Exception {
        String[] ids = this.gav.split(":");
        if (ids.length != 3) {
            this.printer().printErr("--gav must be in syntax: groupId:artifactId:version");
            return 1;
        }
        if (!this.buildTool.equals("maven") && !this.buildTool.equals("gradle")) {
            this.printer().printErr("--build-tool must either be maven or gradle, was: " + this.buildTool);
            return 1;
        }
        if (this.buildTool.equals("gradle")) {
            this.printer().printErr("--build-tool=gradle is not support yet for camel-main runtime.");
        }
        File settings = new File(CommandLineHelper.getWorkDir(), "camel-jbang-run.properties");
        if (this.fresh || !this.files.isEmpty() || !settings.exists()) {
            this.printer().println("Generating fresh run data");
            int silent = this.runSilently(this.ignoreLoadingError, this.lazyBean, this.verbose);
            if (silent != 0) {
                return silent;
            }
        } else {
            this.printer().println("Reusing existing run data");
        }
        this.printer().println("Exporting as Camel Main project to: " + this.exportDir);
        File profile = new File("application.properties");
        File buildDir = new File(".camel-jbang/work");
        FileUtil.removeDir((File)buildDir);
        buildDir.mkdirs();
        Set<String> deps = this.resolveDependencies(settings, profile);
        File srcJavaDirRoot = new File(".camel-jbang/work", "src/main/java");
        String srcPackageName = this.exportPackageName(ids[0], ids[1], this.packageName);
        File srcJavaDir = srcPackageName == null ? srcJavaDirRoot : new File(srcJavaDirRoot, srcPackageName.replace('.', File.separatorChar));
        srcJavaDir.mkdirs();
        File srcResourcesDir = new File(".camel-jbang/work", "src/main/resources");
        srcResourcesDir.mkdirs();
        File srcCamelResourcesDir = new File(".camel-jbang/work", "src/main/resources/camel");
        File srcKameletsResourcesDir = new File(".camel-jbang/work", "src/main/resources/kamelets");
        this.copyApplicationPropertiesFiles(srcResourcesDir);
        this.copySourceFiles(settings, profile, srcJavaDirRoot, srcJavaDir, srcResourcesDir, srcCamelResourcesDir, srcKameletsResourcesDir, srcPackageName);
        this.copySettingsAndProfile(settings, profile, srcResourcesDir, prop -> {
            int port;
            if (!prop.containsKey("camel.main.basePackageScan") && !prop.containsKey("camel.main.base-package-scan")) {
                prop.put("camel.main.basePackageScan", srcPackageName == null ? "." : srcPackageName);
            }
            if (!ExportCamelMain.hasModeline(settings)) {
                prop.remove("camel.main.modeline");
            }
            if ((port = ExportCamelMain.httpServerPort(settings)) == -1 && deps.stream().anyMatch(d -> d.contains("camel-platform-http") || d.contains("camel-rest"))) {
                port = 8080;
            }
            if (port != -1 && !prop.containsKey("camel.server.enabled")) {
                prop.put("camel.server.enabled", "true");
                if (port != 8080 && !prop.containsKey("camel.server.port")) {
                    prop.put("camel.server.port", (Object)port);
                }
                if (!prop.containsKey("camel.server.health-check-enabled")) {
                    prop.put("camel.server.health-check-enabled", "true");
                }
            }
            return prop;
        });
        this.createMainClassSource(srcJavaDir, srcPackageName, this.mainClassname);
        this.copyLocalLibDependencies(deps);
        this.copyAgentDependencies(deps);
        deps.removeIf(d -> d.startsWith("agent:"));
        if ("maven".equals(this.buildTool)) {
            this.createMavenPom(settings, profile, new File(".camel-jbang/work", "pom.xml"), deps, srcPackageName);
            if (this.mavenWrapper) {
                this.copyMavenWrapper();
            }
        }
        this.copyDockerFiles(".camel-jbang/work");
        String appJar = "target" + File.separator + ids[1] + "-" + ids[2] + ".jar";
        this.copyReadme(".camel-jbang/work", appJar);
        if (this.cleanExportDir || !this.exportDir.equals(".")) {
            CommandHelper.cleanExportDir(this.exportDir);
        }
        FileUtils.copyDirectory((File)new File(".camel-jbang/work"), (File)new File(this.exportDir));
        FileUtil.removeDir((File)new File(".camel-jbang/work"));
        return 0;
    }

    private void createMavenPom(File settings, File profile, File pom, Set<String> deps, String packageName) throws Exception {
        String[] ids = this.gav.split(":");
        InputStream is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/" + this.pomTemplateName);
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        if (ObjectHelper.isEmpty((String)this.camelVersion)) {
            this.camelVersion = catalog.getLoadedVersion();
        }
        if (ObjectHelper.isEmpty((String)this.camelVersion)) {
            this.camelVersion = VersionHelper.extractCamelVersion();
        }
        context = context.replaceAll("\\{\\{ \\.GroupId }}", ids[0]);
        context = context.replaceAll("\\{\\{ \\.ArtifactId }}", ids[1]);
        context = context.replaceAll("\\{\\{ \\.Version }}", ids[2]);
        context = context.replaceAll("\\{\\{ \\.JavaVersion }}", this.javaVersion);
        context = context.replaceAll("\\{\\{ \\.CamelVersion }}", this.camelVersion);
        context = packageName != null ? context.replaceAll("\\{\\{ \\.MainClassname }}", packageName + "." + this.mainClassname) : context.replaceAll("\\{\\{ \\.MainClassname }}", this.mainClassname);
        context = context.replaceFirst("\\{\\{ \\.ProjectBuildOutputTimestamp }}", this.getBuildMavenProjectDate());
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String repos = this.getMavenRepositories(settings, (Properties)prop, this.camelVersion);
        context = this.replaceBuildProperties(context);
        if (repos == null || repos.isEmpty()) {
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", "");
        } else {
            String s = ExportCamelMain.mavenRepositoriesAsPomXml(repos);
            context = context.replaceFirst("\\{\\{ \\.MavenRepositories }}", s);
        }
        ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
        for (String dep : deps) {
            MavenGav gav = ExportCamelMain.parseMavenGav(dep);
            String gid = gav.getGroupId();
            if ("org.apache.camel".equals(gid)) {
                gav.setVersion(null);
            }
            gavs.add(gav);
        }
        gavs.sort(this.mavenGavComparator());
        StringBuilder sb = new StringBuilder();
        for (MavenGav gav : gavs) {
            sb.append("        <dependency>\n");
            sb.append("            <groupId>").append(gav.getGroupId()).append("</groupId>\n");
            sb.append("            <artifactId>").append(gav.getArtifactId()).append("</artifactId>\n");
            if (gav.getVersion() != null) {
                sb.append("            <version>").append(gav.getVersion()).append("</version>\n");
            }
            if ("lib".equals(gav.getPackaging())) {
                sb.append("            <scope>system</scope>\n");
                sb.append("            <systemPath>\\$\\{project.basedir}/lib/").append(gav.getArtifactId()).append("-").append(gav.getVersion()).append(".jar</systemPath>\n");
            }
            if ("camel-kamelets-utils".equals(gav.getArtifactId())) {
                sb.append("            <exclusions>\n");
                sb.append("                <exclusion>\n");
                sb.append("                    <groupId>org.apache.camel</groupId>\n");
                sb.append("                    <artifactId>*</artifactId>\n");
                sb.append("                </exclusion>\n");
                sb.append("            </exclusions>\n");
            }
            sb.append("        </dependency>\n");
        }
        context = context.replaceFirst("\\{\\{ \\.CamelDependencies }}", sb.toString());
        context = this.enrichMavenPomJib(context, settings, profile);
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(pom, false));
    }

    protected String enrichMavenPomJib(String context, File settings, File profile) throws Exception {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        if (profile.exists()) {
            RuntimeUtil.loadProperties((Properties)prop, profile);
        }
        boolean jib = prop.stringPropertyNames().stream().anyMatch(s -> s.startsWith("jib."));
        boolean jkube = prop.stringPropertyNames().stream().anyMatch(s -> s.startsWith("jkube."));
        if (jib || jkube) {
            Object fromImage = null;
            for (String key : prop.stringPropertyNames()) {
                boolean accept;
                String value = prop.getProperty(key);
                if ("jib.from.image".equals(key)) {
                    fromImage = value;
                }
                if (!(accept = key.startsWith("jkube.") || key.startsWith("jib.") || key.startsWith("label."))) continue;
                sb1.append(String.format("        <%s>%s</%s>%n", key, value, key));
            }
            if (fromImage == null) {
                fromImage = "eclipse-temurin:" + this.javaVersion + "-jre";
                sb1.append(String.format("        <%s>%s</%s>%n", "jib.from.image", fromImage, "jib.from.image"));
            }
            InputStream is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/main-docker-pom.tmpl");
            String context2 = IOHelper.loadText((InputStream)is);
            IOHelper.close((Closeable)is);
            context2 = context2.replaceFirst("\\{\\{ \\.JibMavenPluginVersion }}", ExportCamelMain.jibMavenPluginVersion(settings, (Properties)prop));
            String auth = "";
            if (prop.stringPropertyNames().stream().anyMatch(s -> s.startsWith("jib.from.auth."))) {
                is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/main-docker-from-auth-pom.tmpl");
                auth = IOHelper.loadText((InputStream)is);
                IOHelper.close((Closeable)is);
            }
            context2 = context2.replace("{{ .JibFromImageAuth }}", auth);
            auth = "";
            if (prop.stringPropertyNames().stream().anyMatch(s -> s.startsWith("jib.to.auth."))) {
                is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/main-docker-to-auth-pom.tmpl");
                auth = IOHelper.loadText((InputStream)is);
                IOHelper.close((Closeable)is);
            }
            context2 = context2.replace("{{ .JibToImageAuth }}", auth);
            int port = ExportCamelMain.httpServerPort(settings);
            if (port == -1) {
                port = 8080;
            }
            context2 = context2.replaceFirst("\\{\\{ \\.Port }}", String.valueOf(port));
            sb2.append(context2);
            if (jkube) {
                is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/main-jkube-pom.tmpl");
                String context3 = IOHelper.loadText((InputStream)is);
                IOHelper.close((Closeable)is);
                context3 = context3.replaceFirst("\\{\\{ \\.JkubeMavenPluginVersion }}", ExportCamelMain.jkubeMavenPluginVersion(settings, (Properties)prop));
                sb2.append(context3);
            }
        }
        String s1 = sb1.toString().replaceAll("(\\r?\\n){2,}", "\n");
        String s2 = sb2.toString().replaceAll("(\\r?\\n){2,}", "\n");
        context = context.replace("{{ .CamelKubernetesProperties }}", s1);
        context = context.replace("{{ .CamelKubernetesPlugins }}", s2);
        return context;
    }

    @Override
    protected Set<String> resolveDependencies(File settings, File profile) throws Exception {
        Set<String> answer = super.resolveDependencies(settings, profile);
        if (profile != null && profile.exists()) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, profile);
            if (prop.getProperty("camel.metrics.enabled") != null || prop.getProperty("camel.server.metricsEnabled") != null) {
                answer.add("mvn:org.apache.camel:camel-micrometer-prometheus");
            }
        }
        answer.removeIf(s -> s.contains("camel-core"));
        answer.removeIf(s -> s.contains("camel-main"));
        answer.removeIf(s -> s.contains("camel-health"));
        boolean main = answer.stream().anyMatch(s -> s.contains("mvn:org.apache.camel:camel-platform-http-main"));
        if (this.hasOpenapi(answer) && !main) {
            answer.add("mvn:org.apache.camel:camel-platform-http-main");
        }
        if (!main && answer.stream().anyMatch(s -> s.contains("camel-platform-http"))) {
            answer.add("mvn:org.apache.camel:camel-platform-http-main");
            main = true;
        }
        if (main) {
            answer.removeIf(s -> s.contains("org.apache.camel:camel-platform-http:"));
            answer.removeIf(s -> s.contains("org.apache.camel:camel-platform-http-vertx:"));
        }
        return answer;
    }

    private void createMainClassSource(File srcJavaDir, String packageName, String mainClassname) throws Exception {
        InputStream is = ExportCamelMain.class.getClassLoader().getResourceAsStream("templates/main.tmpl");
        String context = IOHelper.loadText((InputStream)is);
        IOHelper.close((Closeable)is);
        context = packageName != null ? context.replaceFirst("\\{\\{ \\.PackageName }}", "package " + packageName + ";") : context.replaceFirst("\\{\\{ \\.PackageName }}", "");
        context = context.replaceAll("\\{\\{ \\.MainClassname }}", mainClassname);
        IOHelper.writeText((String)context, (OutputStream)new FileOutputStream(String.valueOf(srcJavaDir) + "/" + mainClassname + ".java", false));
    }

    @Override
    protected void copySourceFiles(File settings, File profile, File srcJavaDirRoot, File srcJavaDir, File srcResourcesDir, File srcCamelResourcesDir, File srcKameletsResourcesDir, String packageName) throws Exception {
        super.copySourceFiles(settings, profile, srcJavaDirRoot, srcJavaDir, srcResourcesDir, srcCamelResourcesDir, srcKameletsResourcesDir, packageName);
        InputStream is = ExportCamelMain.class.getResourceAsStream("/log4j2-main.properties");
        this.safeCopy(is, new File(srcResourcesDir, "log4j2.properties"));
        is = ExportCamelMain.class.getResourceAsStream("/log4j2.component.properties");
        this.safeCopy(is, new File(srcResourcesDir, "log4j2.component.properties"));
        is = ExportCamelMain.class.getResourceAsStream("/assembly/runner.xml");
        this.safeCopy(is, new File(srcResourcesDir, "assembly/runner.xml"));
    }
}

