/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.dsl.jbang.core.commands.CamelCommand;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.CommandHelper;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.Run;
import org.apache.camel.dsl.jbang.core.commands.catalog.KameletCatalogHelper;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.dsl.jbang.core.common.RuntimeCompletionCandidates;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeTypeConverter;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.VersionHelper;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import picocli.CommandLine;

public abstract class ExportBaseCommand
extends CamelCommand {
    protected static final String BUILD_DIR = ".camel-jbang/work";
    protected static final String[] SETTINGS_PROP_SOURCE_KEYS = new String[]{"camel.main.routesIncludePattern", "camel.component.properties.location", "camel.component.kamelet.location", "camel.jbang.classpathFiles", "camel.jbang.localKameletDir", "camel.jbang.jkubeFiles", "kamelet"};
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][.\\w]*)\\s*;.*$", 8);
    private static final Set<String> EXCLUDED_GROUP_IDS = Set.of("org.fusesource.jansi", "org.apache.logging.log4j");
    private MavenDownloader downloader;
    private Printer quietPrinter;
    @CommandLine.Parameters(description={"The Camel file(s) to export. If no files is specified then what was last run will be exported."}, arity="0..9", paramLabel="<files>", parameterConsumer=FilesConsumer.class)
    protected Path[] filePaths;
    protected List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"--repos"}, description={"Additional maven repositories (Use commas to separate multiple repositories)"})
    protected String repositories;
    @CommandLine.Option(names={"--dep", "--dependency"}, description={"Add additional dependencies"}, split=",")
    protected List<String> dependencies = new ArrayList<String>();
    @CommandLine.Option(names={"--runtime"}, completionCandidates=RuntimeCompletionCandidates.class, converter={RuntimeTypeConverter.class}, description={"Runtime (${COMPLETION-CANDIDATES})"})
    protected RuntimeType runtime;
    @CommandLine.Option(names={"--name"}, description={"The integration name. Use this when the name should not get derived otherwise."})
    protected String name;
    @CommandLine.Option(names={"--port"}, description={"Embeds a local HTTP server on this port"}, defaultValue="8080")
    int port;
    @CommandLine.Option(names={"--gav"}, description={"The Maven group:artifact:version"})
    protected String gav;
    @CommandLine.Option(names={"--exclude"}, description={"Exclude files by name or pattern"})
    protected List<String> excludes = new ArrayList<String>();
    @CommandLine.Option(names={"--maven-settings"}, description={"Optional location of Maven settings.xml file to configure servers, repositories, mirrors and proxies. If set to \"false\", not even the default ~/.m2/settings.xml will be used."})
    protected String mavenSettings;
    @CommandLine.Option(names={"--maven-settings-security"}, description={"Optional location of Maven settings-security.xml file to decrypt settings.xml"})
    protected String mavenSettingsSecurity;
    @CommandLine.Option(names={"--maven-central-enabled"}, defaultValue="true", description={"Whether downloading JARs from Maven Central repository is enabled"})
    protected boolean mavenCentralEnabled = true;
    @CommandLine.Option(names={"--maven-apache-snapshot-enabled"}, defaultValue="true", description={"Whether downloading JARs from ASF Maven Snapshot repository is enabled"})
    protected boolean mavenApacheSnapshotEnabled = true;
    @CommandLine.Option(names={"--main-classname"}, description={"The class name of the Camel Main application class"}, defaultValue="CamelApplication")
    protected String mainClassname = "CamelApplication";
    @CommandLine.Option(names={"--java-version"}, description={"Java version"}, defaultValue="17")
    protected String javaVersion = "17";
    @CommandLine.Option(names={"--camel-version"}, description={"To export using a different Camel version than the default version."})
    protected String camelVersion;
    @CommandLine.Option(names={"--kamelets-version"}, description={"Apache Camel Kamelets version"})
    protected String kameletsVersion;
    @CommandLine.Option(names={"--profile"}, scope=CommandLine.ScopeType.INHERIT, description={"Profile to export (dev, test, or prod)."})
    protected String profile;
    @CommandLine.Option(names={"--local-kamelet-dir"}, description={"Local directory for loading Kamelets (takes precedence)"})
    protected String localKameletDir;
    @CommandLine.Option(names={"--spring-boot-version"}, description={"Spring Boot version"}, defaultValue="3.4.6")
    protected String springBootVersion = "3.4.6";
    @CommandLine.Option(names={"--camel-spring-boot-version"}, description={"Camel version to use with Spring Boot"})
    protected String camelSpringBootVersion;
    @CommandLine.Option(names={"--quarkus-group-id"}, description={"Quarkus Platform Maven groupId"}, defaultValue="io.quarkus.platform")
    protected String quarkusGroupId = "io.quarkus.platform";
    @CommandLine.Option(names={"--quarkus-artifact-id"}, description={"Quarkus Platform Maven artifactId"}, defaultValue="quarkus-bom")
    protected String quarkusArtifactId = "quarkus-bom";
    @CommandLine.Option(names={"--quarkus-version"}, description={"Quarkus Platform version"}, defaultValue="3.18.4")
    protected String quarkusVersion = "3.18.4";
    @CommandLine.Option(names={"--maven-wrapper"}, defaultValue="true", description={"Include Maven Wrapper files in exported project"})
    protected boolean mavenWrapper = true;
    @CommandLine.Option(names={"--gradle-wrapper"}, defaultValue="true", description={"Include Gradle Wrapper files in exported project"})
    protected boolean gradleWrapper = true;
    @CommandLine.Option(names={"--build-tool"}, defaultValue="maven", description={"Build tool to use (maven or gradle)"})
    protected String buildTool = "maven";
    @CommandLine.Option(names={"--open-api"}, description={"Adds an OpenAPI spec from the given file (json or yaml file)"})
    protected String openapi;
    @CommandLine.Option(names={"--dir", "--directory"}, description={"Directory where the project will be exported"}, defaultValue=".")
    protected String exportDir;
    @CommandLine.Option(names={"--clean-dir"}, defaultValue="false", description={"If exporting to current directory (default) then all existing files are preserved. Enabling this option will force cleaning current directory including all sub dirs (use this with care)"})
    protected boolean cleanExportDir;
    @CommandLine.Option(names={"--logging-level"}, defaultValue="info", description={"Logging level"})
    protected String loggingLevel = "info";
    @CommandLine.Option(names={"--package-name"}, description={"For Java source files should they have the given package name. By default the package name is computed from the Maven GAV. Use false to turn off and not include package name in the Java source files."})
    protected String packageName;
    @CommandLine.Option(names={"--fresh"}, defaultValue="false", description={"Make sure we use fresh (i.e. non-cached) resources"})
    protected boolean fresh;
    @CommandLine.Option(names={"--download"}, defaultValue="true", description={"Whether to allow automatic downloading JAR dependencies (over the internet)"})
    protected boolean download = true;
    @CommandLine.Option(names={"--build-property"}, description={"Maven/Gradle build properties, ex. --build-property=prop1=foo"})
    protected List<String> buildProperties = new ArrayList<String>();
    @CommandLine.Option(names={"--property"}, description={"Camel application properties, ex. --property=prop1=foo"})
    protected String[] applicationProperties;
    @CommandLine.Option(names={"--logging"}, defaultValue="false", description={"Can be used to turn on logging to console (logs by default to file in <user home>/.camel directory)"})
    protected boolean logging;
    @CommandLine.Option(names={"--quiet"}, defaultValue="false", description={"Will be quiet, only print when error occurs"})
    protected boolean quiet;
    @CommandLine.Option(names={"--verbose"}, defaultValue="false", description={"Verbose output of startup activity (dependency resolution and downloading"})
    protected boolean verbose;
    @CommandLine.Option(names={"--ignore-loading-error"}, defaultValue="false", description={"Whether to ignore route loading and compilation errors (use this with care!)"})
    protected boolean ignoreLoadingError;
    @CommandLine.Option(names={"--lazy-bean"}, defaultValue="true", description={"Whether to use lazy bean initialization (can help with complex classloading issues"})
    protected boolean lazyBean = true;
    protected boolean symbolicLink;
    protected boolean javaLiveReload;
    public String pomTemplateName;

    public ExportBaseCommand(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (this.logging) {
            RuntimeUtil.configureLog(this.loggingLevel, false, false, false, false, null, null);
        } else {
            RuntimeUtil.configureLog(this.loggingLevel, false, false, false, true, null, null);
        }
        if (!this.quiet) {
            this.printConfigurationValues("Exporting integration with the following configuration:");
        }
        return this.export();
    }

    protected static String mavenRepositoriesAsPomXml(String repos) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        sb.append("    <repositories>\n");
        if (!repos.isEmpty()) {
            for (String repo : repos.split(",")) {
                sb.append("        <repository>\n");
                sb.append("            <id>custom").append(i++).append("</id>\n");
                sb.append("            <url>").append(repo).append("</url>\n");
                if (repo.contains("snapshots")) {
                    sb.append("            <releases>\n");
                    sb.append("                <enabled>false</enabled>\n");
                    sb.append("            </releases>\n");
                    sb.append("            <snapshots>\n");
                    sb.append("                <enabled>true</enabled>\n");
                    sb.append("            </snapshots>\n");
                }
                sb.append("        </repository>\n");
            }
        }
        sb.append("    </repositories>\n");
        sb.append("    <pluginRepositories>\n");
        if (!repos.isEmpty()) {
            for (String repo : repos.split(",")) {
                sb.append("        <pluginRepository>\n");
                sb.append("            <id>custom").append(i++).append("</id>\n");
                sb.append("            <url>").append(repo).append("</url>\n");
                if (repo.contains("snapshots")) {
                    sb.append("            <releases>\n");
                    sb.append("                <enabled>false</enabled>\n");
                    sb.append("            </releases>\n");
                    sb.append("            <snapshots>\n");
                    sb.append("                <enabled>true</enabled>\n");
                    sb.append("            </snapshots>\n");
                }
                sb.append("        </pluginRepository>\n");
            }
        }
        sb.append("    </pluginRepositories>\n");
        return sb.toString();
    }

    protected abstract Integer export() throws Exception;

    protected static String getScheme(String name) {
        int pos = name.indexOf(":");
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    protected Integer runSilently(boolean ignoreLoadingError, boolean lazyBean, boolean verbose) throws Exception {
        Run run = new Run(this.getMain());
        run.dependencies = this.dependencies;
        run.files = this.files;
        run.name = this.name;
        run.port = this.port;
        run.excludes = this.excludes;
        run.openapi = this.openapi;
        run.download = this.download;
        run.runtime = this.runtime;
        run.camelVersion = this.camelVersion;
        run.camelSpringBootVersion = this.camelSpringBootVersion;
        run.quarkusVersion = this.quarkusVersion;
        run.quarkusGroupId = this.quarkusGroupId;
        run.springBootVersion = this.springBootVersion;
        run.kameletsVersion = this.kameletsVersion;
        run.localKameletDir = this.localKameletDir;
        run.ignoreLoadingError = ignoreLoadingError;
        run.lazyBean = lazyBean;
        run.property = this.applicationProperties;
        run.repositories = this.repositories;
        run.verbose = verbose;
        run.logging = this.logging;
        return run.runExport(ignoreLoadingError);
    }

    protected void addDependencies(String ... deps) {
        String[] depsArray = Optional.ofNullable(deps).orElse(new String[0]);
        this.dependencies.addAll(Arrays.asList(depsArray));
    }

    protected String replaceBuildProperties(String context) {
        String properties = this.buildProperties.stream().filter(item -> !item.isEmpty()).map(item -> {
            String[] keyValueProperty = item.split("=");
            return String.format("        <%s>%s</%s>", keyValueProperty[0], keyValueProperty[1], keyValueProperty[0]);
        }).collect(Collectors.joining(System.lineSeparator()));
        context = !properties.isEmpty() ? context.replaceFirst(Pattern.quote("{{ .BuildProperties }}"), Matcher.quoteReplacement(properties)) : context.replaceFirst(Pattern.quote("{{ .BuildProperties }}"), "");
        return context;
    }

    protected Set<String> resolveDependencies(File settings, File profile) throws Exception {
        TreeSet<String> answer = new TreeSet<String>((o1, o2) -> {
            boolean c1 = o1.contains("org.apache.camel:");
            boolean c2 = o2.contains("org.apache.camel:");
            if (c1 && !c2) {
                return -1;
            }
            if (!c1 && c2) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        for (String d : this.dependencies) {
            answer.add(ExportBaseCommand.normalizeDependency(d));
        }
        List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
        List<String> officialKamelets = KameletCatalogHelper.findKameletNames(this.kameletsVersion);
        boolean kamelets = false;
        boolean asfKamelets = false;
        for (String string : lines) {
            if (!string.startsWith("kamelet=")) continue;
            kamelets = true;
            String name = StringHelper.after((String)string, (String)"kamelet=");
            if (!officialKamelets.contains(name)) continue;
            asfKamelets = true;
            break;
        }
        kamelets |= lines.stream().anyMatch(l -> l.startsWith("camel.main.routesIncludePattern=") && l.contains(".kamelet.yaml") || l.startsWith("camel.component.kamelet.location=") && l.contains(".kamelet.yaml"));
        for (String string : lines) {
            String deps;
            if (string.startsWith("dependency=")) {
                int skip;
                String v = StringHelper.after((String)string, (String)"dependency=");
                int n = skip = v == null || v.contains("org.apache.camel:camel-core-languages") || v.contains("org.apache.camel:camel-java-joor-dsl") || v.contains("camel-endpointdsl") || !kamelets && v.contains("org.apache.camel:camel-kamelet") ? 1 : 0;
                if (skip == 0) {
                    answer.add(v);
                }
                if (!kamelets || v == null || !v.contains("org.apache.camel:camel-kamelet")) continue;
                answer.add("camel:yaml-dsl");
                if (!asfKamelets) continue;
                answer.add("org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                answer.add("org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                continue;
            }
            if (string.startsWith("camel.jbang.dependencies=")) {
                deps = StringHelper.after((String)string, (String)"camel.jbang.dependencies=");
                if (deps.isEmpty()) continue;
                for (String d : deps.split(",")) {
                    answer.add(d.trim());
                    if (!kamelets || !d.contains("org.apache.camel:camel-kamelet")) continue;
                    answer.add("camel:yaml-dsl");
                    if (!asfKamelets) continue;
                    answer.add("org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                    if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                    answer.add("org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                }
                continue;
            }
            if (string.startsWith("camel.jbang.classpathFiles")) {
                deps = StringHelper.after((String)string, (String)"camel.jbang.classpathFiles=");
                if (deps.isEmpty()) continue;
                for (String d : deps.split(",")) {
                    if (!d.endsWith(".jar")) continue;
                    answer.add("lib:" + d.trim());
                }
                continue;
            }
            if (string.startsWith("camel.main.routesIncludePattern=")) {
                String routes = StringHelper.after((String)string, (String)"camel.main.routesIncludePattern=");
                if (routes.isEmpty()) continue;
                for (String r : routes.split(",")) {
                    String ext = FileUtil.onlyExt((String)r, (boolean)true);
                    if (ext == null) continue;
                    if ("xml".equals(ext)) {
                        answer.add("mvn:org.apache.camel:camel-xml-io-dsl");
                        continue;
                    }
                    if (!"yaml".equals(ext)) continue;
                    answer.add("mvn:org.apache.camel:camel-yaml-dsl");
                    ext = FileUtil.onlyExt((String)r, (boolean)false);
                    if (!"kamelet.yaml".equals(ext)) continue;
                    answer.add("camel:kamelet");
                    if (!asfKamelets) continue;
                    answer.add("mvn:org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                    if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                    answer.add("mvn:org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                }
                continue;
            }
            if (kamelets && string.startsWith("camel.component.kamelet.location=")) {
                answer.add("camel:kamelet");
                answer.add("camel:yaml-dsl");
                if (!asfKamelets) continue;
                answer.add("mvn:org.apache.camel.kamelets:camel-kamelets:" + this.kameletsVersion);
                if (VersionHelper.compare(this.camelVersion, "4.10.0") >= 0) continue;
                answer.add("mvn:org.apache.camel.kamelets:camel-kamelets-utils:" + this.kameletsVersion);
                continue;
            }
            if (!string.startsWith("modeline=")) continue;
            answer.add("camel:dsl-modeline");
        }
        if (profile != null && profile.exists()) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, profile);
            for (String d : RuntimeUtil.getDependenciesAsArray((Properties)prop)) {
                answer.add(d.trim());
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.main.devConsoleEnabled")) || "true".equalsIgnoreCase(prop.getProperty("camel.server.devConsoleEnabled"))) {
                answer.add("camel:console");
                answer.add("camel:management");
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.server.jolokiaEnabled"))) {
                answer.add("camel:platform-http-jolokia");
            }
            if ("true".equalsIgnoreCase(prop.getProperty("camel.server.metricsEnabled"))) {
                answer.add("camel:micrometer-prometheus");
            }
        }
        HashMap<CallSite, String> versions = new HashMap<CallSite, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String line : answer) {
            MavenGav gav = MavenGav.parseGav((String)line);
            String ga = gav.getGroupId() + ":" + gav.getArtifactId();
            if (!versions.containsKey(ga)) {
                versions.put((CallSite)((Object)ga), gav.getVersion());
                continue;
            }
            hashSet.add(line);
        }
        answer.removeAll(hashSet);
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copySourceFiles(File settings, File profile, File srcJavaDirRoot, File srcJavaDir, File srcResourcesDir, File srcCamelResourcesDir, File srcKameletsResourcesDir, String packageName) throws Exception {
        String scheme;
        CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)prop, settings);
        String localKameletDir = prop.getProperty("camel.jbang.localKameletDir");
        if (localKameletDir != null && (scheme = ExportBaseCommand.getScheme(localKameletDir)) != null) {
            localKameletDir = localKameletDir.substring(scheme.length() + 1);
        }
        for (String k : SETTINGS_PROP_SOURCE_KEYS) {
            String files = "kamelet".equals(k) ? RuntimeUtil.loadPropertiesLines(settings).stream().filter(l -> l.startsWith("kamelet=")).map(l -> StringHelper.after((String)l, (String)"=")).collect(Collectors.joining(",")) : prop.getProperty(k);
            if (files == null || files.isEmpty()) continue;
            for (String f : files.split(",")) {
                boolean skip;
                String scheme2 = ExportBaseCommand.getScheme(f);
                if (scheme2 != null) {
                    f = f.substring(scheme2.length() + 1);
                }
                if ((skip = profile.getName().equals(f)) || "github".equals(scheme2)) continue;
                String ext = FileUtil.onlyExt((String)f, (boolean)true);
                String ext2 = FileUtil.onlyExt((String)f, (boolean)false);
                if (!"kamelet".equals(k) && ext == null) continue;
                boolean java = "java".equals(ext);
                boolean kamelet = "kamelet".equals(k) || "camel.component.kamelet.location".equals(k) || "camel.jbang.localKameletDir".equals(k) || "kamelet.yaml".equalsIgnoreCase(ext2);
                boolean camel = !kamelet && "camel.main.routesIncludePattern".equals(k);
                boolean jkube = "camel.jbang.jkubeFiles".equals(k);
                boolean web = "html".equals(ext) || "js".equals(ext) || "css".equals(ext) || "jpeg".equals(ext) || "jpg".equals(ext) || "png".equals(ext) || "ico".equals(ext);
                File srcWeb = new File(srcResourcesDir, "META-INF/resources");
                File targetDir = java ? srcJavaDir : (camel ? srcCamelResourcesDir : (kamelet ? srcKameletsResourcesDir : (web ? srcWeb : srcResourcesDir)));
                targetDir.mkdirs();
                File source = "kamelet".equals(k) && localKameletDir != null ? new File(localKameletDir, f + ".kamelet.yaml") : new File(f);
                File out = source.isDirectory() ? targetDir : new File(targetDir, source.getName());
                if (!java) {
                    if (kamelet) {
                        this.safeCopy(source, out, true);
                        continue;
                    }
                    if (jkube) {
                        f = f.replace(".jkube.yaml", ".yaml");
                        f = f.replace(".jkube.yml", ".yml");
                        out = new File(srcCamelResourcesDir.getParentFile().getParentFile(), "jkube/" + f);
                        out.getParentFile().mkdirs();
                        this.safeCopy(source, out, true);
                        continue;
                    }
                    out.getParentFile().mkdirs();
                    this.safeCopy(source, out, true);
                    continue;
                }
                List<String> lines = Files.readAllLines(source.toPath());
                Optional<String> hasPackage = lines.stream().filter(l -> l.trim().startsWith("package ")).findFirst();
                if (hasPackage.isPresent()) {
                    String pn = ExportBaseCommand.determinePackageName(hasPackage.get());
                    if (pn == null) throw new IOException("Cannot determine package name from source: " + String.valueOf(source));
                    File dir = new File(srcJavaDirRoot, pn.replace('.', File.separatorChar));
                    dir.mkdirs();
                    out = new File(dir, source.getName());
                } else if (this.javaLiveReload) {
                    out = new File(srcJavaDirRoot, source.getName());
                } else if (packageName != null && !"false".equalsIgnoreCase(packageName)) {
                    lines.add(0, "");
                    lines.add(0, "package " + packageName + ";");
                }
                if (this.javaLiveReload) {
                    this.safeCopy(source, out, true);
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(out);
                for (String line : lines) {
                    this.adjustJavaSourceFileLine(line, fos);
                    fos.write(line.getBytes(StandardCharsets.UTF_8));
                    fos.write("\n".getBytes(StandardCharsets.UTF_8));
                }
                IOHelper.close((Closeable)fos);
            }
        }
    }

    protected void adjustJavaSourceFileLine(String line, FileOutputStream fos) throws Exception {
    }

    protected String exportPackageName(String groupId, String artifactId, String packageName) {
        if ("false".equalsIgnoreCase(packageName)) {
            return null;
        }
        if (packageName != null) {
            return packageName;
        }
        String s = groupId + "." + artifactId;
        StringBuilder sb = new StringBuilder();
        for (char ch : s.toCharArray()) {
            if (ch != '.' && !Character.isAlphabetic(ch) && !Character.isDigit(ch)) continue;
            ch = Character.toLowerCase(ch);
            sb.append(ch);
        }
        return sb.toString();
    }

    protected void copySettingsAndProfile(File settings, File profile, File targetDir, Function<Properties, Object> customize) throws Exception {
        CamelCaseOrderedProperties settingsProps = new CamelCaseOrderedProperties();
        RuntimeUtil.loadProperties((Properties)settingsProps, settings);
        CamelCaseOrderedProperties profileProps = new CamelCaseOrderedProperties();
        if (profile.exists()) {
            RuntimeUtil.loadProperties((Properties)profileProps, profile);
        }
        profileProps.putAll((Map<?, ?>)settingsProps);
        this.prepareApplicationProperties((Properties)profileProps);
        for (Map.Entry<Object, Object> entry : settingsProps.entrySet()) {
            String key = entry.getKey().toString();
            boolean skip = !key.startsWith("camel.main") || "camel.main.routesCompileDirectory".equals(key) || "camel.main.routesReloadEnabled".equals(key);
            if (!skip) continue;
            profileProps.remove(key);
        }
        if (customize != null) {
            customize.apply((Properties)profileProps);
        }
        CamelCaseOrderedProperties userProps = new CamelCaseOrderedProperties();
        this.prepareUserProperties((Properties)userProps);
        try (FileOutputStream fos = new FileOutputStream(new File(targetDir, "application.properties"), false);){
            for (Map.Entry<Object, Object> entry : profileProps.entrySet()) {
                String line;
                boolean skip;
                String k = entry.getKey().toString();
                String v = entry.getValue().toString();
                boolean bl = skip = k.startsWith("camel.jbang.") || k.startsWith("jkube.");
                if (skip) continue;
                v = v.replaceAll("file:", "classpath:");
                if ("camel.main.routesIncludePattern".equals(k)) {
                    v = Arrays.stream(v.split(",")).filter(n -> !n.endsWith(".java") && !n.startsWith("file:") && !n.startsWith("classpath:")).collect(Collectors.joining(","));
                }
                if (v.isBlank() || (line = this.applicationPropertyLine(k, v)) == null || line.isBlank()) continue;
                fos.write(line.getBytes(StandardCharsets.UTF_8));
                fos.write("\n".getBytes(StandardCharsets.UTF_8));
            }
            for (Map.Entry<Object, Object> entryUserProp : userProps.entrySet()) {
                String uV;
                String uK = entryUserProp.getKey().toString();
                String line = this.applicationPropertyLine(uK, uV = entryUserProp.getValue().toString());
                if (line == null || line.isBlank()) continue;
                fos.write(line.getBytes(StandardCharsets.UTF_8));
                fos.write("\n".getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    protected void prepareApplicationProperties(Properties properties) {
    }

    protected void prepareUserProperties(Properties properties) {
        if (this.applicationProperties != null) {
            for (String s : this.applicationProperties) {
                String[] kv = s.split("=");
                if (kv.length != 2) {
                    this.printer().println("WARN: property '" + s + "'' has a bad format (should be 'key=value'), skipping.");
                    continue;
                }
                properties.put(kv[0], kv[1]);
            }
        }
    }

    protected boolean hasOpenapi(Set<String> dependencies) {
        return this.openapi != null || dependencies.stream().anyMatch(s -> s.contains("mvn:org.apache.camel:camel-rest-openapi"));
    }

    protected Properties mapBuildProperties() {
        Properties answer = new Properties();
        this.buildProperties.stream().map(item -> item.split("=")).forEach(toks -> answer.setProperty(toks[0], toks[1]));
        return answer;
    }

    protected void copyMavenWrapper() throws Exception {
        File wrapper = new File(BUILD_DIR, ".mvn/wrapper");
        wrapper.mkdirs();
        InputStream is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/mvnw");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(BUILD_DIR, "mvnw")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/mvnw.cmd");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(BUILD_DIR, "mvnw.cmd")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/maven-wrapper.jar");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(wrapper, "maven-wrapper.jar")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("maven-wrapper/maven-wrapper.properties");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(wrapper, "maven-wrapper.properties")));
        File file = new File(BUILD_DIR, "mvnw");
        file.setExecutable(true);
        file = new File(BUILD_DIR, "mvnw.cmd");
        file.setExecutable(true);
    }

    protected void copyGradleWrapper() throws Exception {
        File wrapper = new File(BUILD_DIR, "gradle/wrapper");
        wrapper.mkdirs();
        InputStream is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradlew");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(BUILD_DIR, "gradlew")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradlew.bat");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(BUILD_DIR, "gradlew.bat")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradle-wrapper.jar");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(wrapper, "gradle-wrapper.jar")));
        is = ExportBaseCommand.class.getClassLoader().getResourceAsStream("gradle-wrapper/gradle-wrapper.properties");
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)new FileOutputStream(new File(wrapper, "gradle-wrapper.properties")));
        File file = new File(BUILD_DIR, "gradlew");
        file.setExecutable(true);
        file = new File(BUILD_DIR, "gradlew.bat");
        file.setExecutable(true);
    }

    protected String applicationPropertyLine(String key, String value) {
        return key + "=" + value;
    }

    protected String getMavenRepositories(File settings, Properties prop, String camelVersion) throws Exception {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        String propRepositories = prop.getProperty("camel.jbang.repositories");
        if (propRepositories != null) {
            answer.add(propRepositories);
        }
        if (camelVersion == null) {
            camelVersion = new DefaultCamelCatalog().getCatalogVersion();
        }
        if (camelVersion.endsWith("-SNAPSHOT")) {
            answer.add("https://repository.apache.org/content/groups/snapshots/");
        }
        List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
        for (String line : lines) {
            if (!line.startsWith("repository=")) continue;
            String r = StringHelper.after((String)line, (String)"repository=");
            answer.add(r);
        }
        if (this.repositories != null) {
            Collections.addAll(answer, this.repositories.split(","));
        }
        return answer.stream().filter(item -> !item.isEmpty()).collect(Collectors.joining(","));
    }

    protected static boolean hasModeline(File settings) {
        try {
            List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
            return lines.stream().anyMatch(l -> l.startsWith("modeline="));
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static int httpServerPort(File settings) {
        try {
            List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
            String port = lines.stream().filter(l -> l.startsWith("camel.jbang.platform-http.port=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse("-1");
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected static String jibMavenPluginVersion(File settings, Properties prop) {
        String answer = null;
        if (prop != null) {
            answer = prop.getProperty("camel.jbang.jib-maven-plugin-version");
        }
        if (answer == null) {
            try {
                List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
                answer = lines.stream().filter(l -> l.startsWith("camel.jbang.jib-maven-plugin-version=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer != null ? answer : "3.4.3";
    }

    protected static String jkubeMavenPluginVersion(File settings, Properties props) {
        String answer = null;
        if (props != null) {
            answer = props.getProperty("camel.jbang.jkube-maven-plugin-version");
        }
        if (answer == null) {
            try {
                List<String> lines = RuntimeUtil.loadPropertiesLines(settings);
                answer = lines.stream().filter(l -> l.startsWith("camel.jbang.jkube-maven-plugin-version=") || l.startsWith("jkube.version=")).map(s -> StringHelper.after((String)s, (String)"=")).findFirst().orElse(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return answer != null ? answer : "1.18.0";
    }

    protected void safeCopy(File source, File target, boolean override) throws Exception {
        if (!source.exists()) {
            return;
        }
        if (source.isDirectory()) {
            File[] children = source.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (!child.isFile()) continue;
                    this.safeCopy(child, new File(target, child.getName()), override);
                }
            }
            return;
        }
        if (this.symbolicLink) {
            try {
                Path link = target.toPath().toAbsolutePath();
                Path src = source.toPath().toAbsolutePath();
                if (Files.exists(link, new LinkOption[0])) {
                    Files.delete(link);
                }
                Files.createSymbolicLink(link, src, new FileAttribute[0]);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!target.exists()) {
            Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
        } else if (override) {
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected void safeCopy(InputStream source, File target) throws Exception {
        if (source == null) {
            return;
        }
        File dir = target.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!target.exists()) {
            Files.copy(source, target.toPath(), new CopyOption[0]);
        }
    }

    private static String determinePackageName(String content) {
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String normalizeDependency(String dependency) {
        if (dependency.startsWith("camel-quarkus-")) {
            return "camel:" + dependency.substring("camel-quarkus-".length());
        }
        if (dependency.startsWith("camel-quarkus:")) {
            return "camel:" + dependency.substring("camel-quarkus:".length());
        }
        if (dependency.startsWith("camel-")) {
            return "camel:" + dependency.substring("camel-".length());
        }
        return dependency;
    }

    protected static MavenGav parseMavenGav(String dep) {
        MavenGav gav;
        if (dep.startsWith("lib:") && dep.endsWith(".jar")) {
            String n = dep.substring(4);
            gav = ExportBaseCommand.parseLocalJar(n = n.substring(0, n.length() - 4));
            if (gav == null) {
                gav = new MavenGav();
                String v = "1.0";
                String a = n;
                int pos = n.lastIndexOf("-");
                if (pos != -1) {
                    a = n.substring(0, pos);
                    v = n.substring(pos + 1);
                }
                gav.setGroupId("local");
                gav.setArtifactId(a);
                gav.setVersion(v);
                gav.setPackaging("lib");
            }
        } else {
            gav = MavenGav.parseGav((String)dep);
        }
        return gav;
    }

    private static MavenGav parseLocalJar(String dep) {
        File file = new File(dep + ".jar");
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        try {
            JarFile jf = new JarFile(file);
            Optional<JarEntry> je = jf.stream().filter(e -> e.getName().startsWith("META-INF/maven/") && e.getName().endsWith("/pom.properties")).findFirst();
            if (je.isPresent()) {
                JarEntry e2 = je.get();
                InputStream is = jf.getInputStream(e2);
                Properties prop = new Properties();
                prop.load(is);
                IOHelper.close((Closeable)is);
                MavenGav gav = new MavenGav();
                gav.setGroupId(prop.getProperty("groupId"));
                gav.setArtifactId(prop.getProperty("artifactId"));
                gav.setVersion(prop.getProperty("version"));
                gav.setPackaging("lib");
                return gav;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void copyLocalLibDependencies(Set<String> deps) throws Exception {
        for (String d : deps) {
            if (!d.startsWith("lib:")) continue;
            File libDir = new File(BUILD_DIR, "lib");
            libDir.mkdirs();
            String n = d.substring(4);
            File source = new File(n);
            File target = new File(libDir, n);
            this.safeCopy(source, target, true);
        }
    }

    protected void copyAgentDependencies(Set<String> deps) throws Exception {
        for (String d : deps) {
            if (!d.startsWith("agent:")) continue;
            File libDir = new File(BUILD_DIR, "agent");
            libDir.mkdirs();
            String n = d.substring(6);
            MavenGav gav = MavenGav.parseGav((String)n);
            this.copyAgentLibDependencies(gav);
        }
    }

    private void copyAgentLibDependencies(MavenGav gav) {
        try {
            List artifacts = this.getDownloader().resolveArtifacts(List.of(gav.toString()), Set.of(), true, gav.getVersion().contains("SNAPSHOT"));
            for (MavenArtifact artifact : artifacts) {
                Path target = Paths.get(BUILD_DIR, "agent", artifact.getFile().getName());
                if (Files.exists(target, new LinkOption[0]) || EXCLUDED_GROUP_IDS.contains(artifact.getGav().getGroupId())) continue;
                Files.copy(artifact.getFile().toPath(), target, new CopyOption[0]);
            }
        }
        catch (MavenResolutionException e) {
            this.printer().printErr("Error resolving the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
        catch (IOException e) {
            this.printer().printErr("Error copying the artifact: " + String.valueOf(gav) + " due to: " + e.getMessage());
        }
    }

    protected void copyApplicationPropertiesFiles(File srcResourcesDir) throws Exception {
        File[] files = new File(".").listFiles(f -> {
            if (!f.isFile()) {
                return false;
            }
            String ext = FileUtil.onlyExt((String)f.getName());
            String name = FileUtil.onlyName((String)f.getName());
            if (!"properties".equals(ext)) {
                return false;
            }
            if (name.equals("application")) {
                return false;
            }
            if (this.profile == null) {
                return name.startsWith("application");
            }
            return name.equals("application-" + this.profile);
        });
        if (files != null) {
            for (File f2 : files) {
                this.safeCopy(f2, new File(srcResourcesDir, f2.getName()), true);
            }
        }
    }

    private MavenDownloader getDownloader() {
        if (this.downloader == null) {
            this.init();
        }
        return this.downloader;
    }

    private void init() {
        this.downloader = new MavenDownloaderImpl();
        ((MavenDownloaderImpl)this.downloader).build();
    }

    protected Printer outPrinter() {
        return super.printer();
    }

    @Override
    protected Printer printer() {
        if (this.quiet) {
            if (this.quietPrinter == null) {
                this.quietPrinter = new Printer.QuietPrinter(super.printer());
            }
            CommandHelper.setPrinter(this.quietPrinter);
            return this.quietPrinter;
        }
        return super.printer();
    }

    static class FilesConsumer
    extends CamelCommand.ParameterConsumer<Export> {
        FilesConsumer() {
        }

        @Override
        protected void doConsumeParameters(Stack<String> args, Export cmd) {
            String arg = args.pop();
            cmd.files.add(arg);
        }
    }
}

