/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.DependencyList;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.apache.logging.log4j.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates dependencies in Maven pom.xml or Java source file (JBang style)"}, sortOptions=false, showDefaultValues=true)
public class DependencyUpdate
extends DependencyList {
    @CommandLine.Parameters(description={"Maven pom.xml or Java source files (JBang Style with //DEPS) to have dependencies updated"}, arity="1")
    public File file;
    @CommandLine.Option(names={"--clean"}, description={"Regenerate list of dependencies (do not keep existing dependencies). Not supported for pom.xml"})
    protected boolean clean;
    private final List<String> deps = new ArrayList<String>();
    private final List<MavenGav> gavs = new ArrayList<MavenGav>();

    public DependencyUpdate(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        if (!this.file.exists()) {
            this.printer().printErr("Source file does not exist: " + String.valueOf(this.file));
            return -1;
        }
        boolean maven = "pom.xml".equals(this.file.getName());
        if (this.clean && !maven) {
            this.updateJBangSource();
        }
        return super.doCall();
    }

    @Override
    protected void outputGav(MavenGav gav, int index, int total) {
        try {
            boolean maven = "pom.xml".equals(this.file.getName());
            if (maven) {
                this.outputGavMaven(gav, index, total);
            } else {
                this.outputGavJBang(gav, index, total);
            }
        }
        catch (Exception e) {
            this.printer().printErr("Cannot update dependencies due to " + e.getMessage(), e);
        }
    }

    protected void outputGavMaven(MavenGav gav, int index, int total) throws Exception {
        boolean last;
        this.gavs.add(gav);
        boolean bl = last = total - index <= 1;
        if (last) {
            this.updateMavenSource();
        }
    }

    protected void outputGavJBang(MavenGav gav, int index, int total) {
        boolean last;
        String line;
        if (index == 0) {
            this.deps.add("//DEPS org.apache.camel:camel-bom:" + gav.getVersion() + "@pom");
        }
        if (gav.getGroupId().equals("org.apache.camel")) {
            gav.setVersion(null);
        }
        if (!this.deps.contains(line = "//DEPS " + String.valueOf(gav))) {
            this.deps.add(line);
        }
        boolean bl = last = total - index <= 1;
        if (last) {
            this.updateJBangSource();
        }
    }

    private void updateJBangSource() {
        try {
            List<String> lines = Files.readAllLines(this.file.toPath());
            ArrayList<String> answer = new ArrayList<String>();
            int pos = -1;
            for (int i = 0; i < lines.size(); ++i) {
                String l = lines.get(i);
                if (l.trim().startsWith("//DEPS ")) {
                    if (pos != -1) continue;
                    pos = i;
                    continue;
                }
                answer.add(l);
            }
            if (pos == -1 && ((String)answer.get(0)).trim().startsWith("///usr/bin/env jbang")) {
                pos = 1;
            }
            if (pos == -1) {
                pos = 0;
            }
            Collections.reverse(this.deps);
            for (String dep : this.deps) {
                answer.add(pos, dep);
            }
            String text = String.join((CharSequence)System.lineSeparator(), answer);
            IOHelper.writeText((String)text, (File)this.file);
        }
        catch (Exception e) {
            this.printer().printErr("Error updating source file: " + String.valueOf(this.file) + " due to: " + e.getMessage());
        }
    }

    private void updateMavenSource() throws Exception {
        ArrayList<MavenGav> existingGavs = new ArrayList<MavenGav>();
        Node camelClone = null;
        int targetLineNumber = -1;
        File pom = new File(this.file.getName());
        if (pom.exists()) {
            Document dom = XmlLineNumberParser.parseXml((InputStream)new FileInputStream(pom));
            String camelVersion = null;
            NodeList nl = dom.getElementsByTagName("dependency");
            for (int i = 0; i < nl.getLength(); ++i) {
                String num;
                boolean bl;
                Element node = (Element)nl.item(i);
                String p = node.getParentNode().getNodeName();
                String p2 = node.getParentNode().getParentNode().getNodeName();
                boolean bl2 = bl = ("dependencyManagement".equals(p2) || "project".equals(p2)) && p.equals("dependencies");
                if (!bl) continue;
                String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                String v = null;
                NodeList vl = node.getElementsByTagName("version");
                if (vl.getLength() > 0) {
                    v = vl.item(0).getTextContent();
                }
                Object scope = null;
                vl = node.getElementsByTagName("scope");
                if (vl.getLength() > 0) {
                    scope = vl.item(0).getTextContent();
                }
                if (scope != null && !"compile".equals(scope)) continue;
                if ("org.apache.camel".equals(g)) {
                    camelVersion = v;
                    if (camelClone == null && !"camel-bom".equals(a)) {
                        camelClone = node.cloneNode(true);
                    }
                    if ((num = (String)node.getUserData("lineNumberEnd")) != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                    if ((num = (String)node.getUserData("lineNumberEnd")) != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                }
                if ("org.apache.camel.springboot".equals(g)) {
                    camelVersion = v;
                    num = (String)node.getUserData("lineNumberEnd");
                    if (num != null) {
                        targetLineNumber = Integer.parseInt(num);
                    }
                }
                if ("org.apache.camel.quarkus".equals(g) && (num = (String)node.getUserData("lineNumberEnd")) != null) {
                    targetLineNumber = Integer.parseInt(num);
                }
                if (v != null) {
                    existingGavs.add(MavenGav.parseGav((String)(g + ":" + a + ":" + v)));
                    continue;
                }
                existingGavs.add(MavenGav.parseGav((String)(g + ":" + a)));
            }
            ArrayList<Object> updates = new ArrayList<Object>();
            for (MavenGav gav : this.gavs) {
                MavenGav target = camelVersion != null ? MavenGav.parseGav((String)(gav.getGroupId() + ":" + gav.getArtifactId() + ":" + camelVersion)) : MavenGav.parseGav((String)(gav.getGroupId() + ":" + gav.getArtifactId()));
                updates.add(target);
            }
            updates.sort(this.mavenGavComparator());
            ArrayList<MavenGav> toBeUpdated = new ArrayList<MavenGav>();
            int changes = 0;
            for (MavenGav mavenGav : updates) {
                if (existingGavs.contains(mavenGav)) continue;
                toBeUpdated.add(mavenGav);
                ++changes;
            }
            if (changes > 0) {
                String line = IOHelper.loadTextLine((InputStream)new FileInputStream(this.file), (int)targetLineNumber);
                line = StringHelper.before((String)line, (String)"<");
                int n = StringHelper.countChar((String)line, (char)' ');
                String pad = Strings.repeat((String)" ", (int)n);
                line = IOHelper.loadTextLine((InputStream)new FileInputStream(this.file), (int)(targetLineNumber - 1));
                line = StringHelper.before((String)line, (String)"<");
                int indent2 = StringHelper.countChar((String)line, (char)' ');
                String pad2 = Strings.repeat((String)" ", (int)indent2);
                StringJoiner sj = new StringJoiner("");
                for (MavenGav gav : toBeUpdated) {
                    sj.add(pad).add("<dependency>\n");
                    sj.add(pad2).add("<groupId>" + gav.getGroupId() + "</groupId>\n");
                    sj.add(pad2).add("<artifactId>" + gav.getArtifactId() + "</artifactId>\n");
                    if (gav.getVersion() != null) {
                        sj.add(pad2).add("<version>" + gav.getVersion() + "</version>\n");
                    }
                    sj.add(pad).add("</dependency>");
                }
                StringJoiner out = new StringJoiner("\n");
                String[] lines = IOHelper.loadText((InputStream)new FileInputStream(this.file)).split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    String txt = lines[i];
                    out.add(txt);
                    if (i != targetLineNumber - 1) continue;
                    out.add(sj.toString());
                }
                if (changes > 1) {
                    this.outPrinter().println("Updating pom.xml with " + changes + " dependencies added");
                } else {
                    this.outPrinter().println("Updating pom.xml with 1 dependency added");
                }
                IOHelper.writeText((String)out.toString(), (File)this.file);
            } else {
                this.outPrinter().println("No updates to pom.xml");
            }
        }
    }
}

