/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.dsl.jbang.core.commands.CamelJBangMain;
import org.apache.camel.dsl.jbang.core.commands.Export;
import org.apache.camel.dsl.jbang.core.commands.ExportCamelMain;
import org.apache.camel.dsl.jbang.core.commands.ExportQuarkus;
import org.apache.camel.dsl.jbang.core.commands.ExportSpringBoot;
import org.apache.camel.dsl.jbang.core.common.RuntimeType;
import org.apache.camel.dsl.jbang.core.common.RuntimeUtil;
import org.apache.camel.dsl.jbang.core.common.XmlHelper;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.CamelCaseOrderedProperties;
import org.apache.camel.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Displays all Camel dependencies required to run"}, sortOptions=false, showDefaultValues=true)
public class DependencyList
extends Export {
    protected static final String EXPORT_DIR = ".camel-jbang/export";
    @CommandLine.Option(names={"--output"}, description={"Output format (gav, maven, jbang)"}, defaultValue="gav")
    protected String output;

    public DependencyList(CamelJBangMain main) {
        super(main);
    }

    @Override
    public Integer doCall() throws Exception {
        this.quiet = true;
        return super.doCall();
    }

    @Override
    protected Integer export() throws Exception {
        Integer answer;
        if (!("gav".equals(this.output) || "maven".equals(this.output) || "jbang".equals(this.output))) {
            this.printer().printErr("--output must be either gav or maven, was: " + this.output);
            return 1;
        }
        if (this.files.isEmpty()) {
            if (new File("pom.xml").exists()) {
                this.files.add("pom.xml");
            } else if (new File("build.gradle").exists()) {
                this.files.add("build.gradle");
            }
        }
        if ((answer = this.doExport()) == 0) {
            File pom = new File(EXPORT_DIR, "pom.xml");
            if (pom.exists()) {
                int i;
                DocumentBuilderFactory dbf = XmlHelper.createDocumentBuilderFactory();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(pom);
                NodeList nl = dom.getElementsByTagName("dependency");
                ArrayList<MavenGav> gavs = new ArrayList<MavenGav>();
                String camelVersion = null;
                String springBootVersion = null;
                String quarkusVersion = null;
                for (i = 0; i < nl.getLength(); ++i) {
                    boolean accept;
                    Element node = (Element)nl.item(i);
                    String p = node.getParentNode().getNodeName();
                    String p2 = node.getParentNode().getParentNode().getNodeName();
                    boolean bl = accept = ("dependencyManagement".equals(p2) || "project".equals(p2)) && p.equals("dependencies");
                    if (!accept) continue;
                    String g = node.getElementsByTagName("groupId").item(0).getTextContent();
                    String a = node.getElementsByTagName("artifactId").item(0).getTextContent();
                    String v = null;
                    NodeList vl = node.getElementsByTagName("version");
                    if (vl.getLength() > 0) {
                        v = vl.item(0).getTextContent();
                    }
                    if ("org.apache.camel".equals(g) && "camel-bom".equals(a)) {
                        camelVersion = v;
                        continue;
                    }
                    if ("org.apache.camel.springboot".equals(g) && "camel-spring-boot-bom".equals(a)) {
                        camelVersion = v;
                        continue;
                    }
                    if ("org.springframework.boot".equals(g) && "spring-boot-dependencies".equals(a)) {
                        springBootVersion = v;
                        continue;
                    }
                    if (("${quarkus.platform.group-id}".equals(g) || "io.quarkus.platform".equals(g)) && ("${quarkus.platform.artifact-id}".equals(a) || "quarkus-bom".equals(a))) {
                        if ("${quarkus.platform.version}".equals(v)) {
                            quarkusVersion = dom.getElementsByTagName("quarkus.platform.version").item(0).getTextContent();
                            continue;
                        }
                        quarkusVersion = v;
                        continue;
                    }
                    String scope = null;
                    NodeList sl = node.getElementsByTagName("scope");
                    if (sl.getLength() > 0) {
                        scope = sl.item(0).getTextContent();
                    }
                    if ("test".equals(scope) || "import".equals(scope)) continue;
                    if (v == null && g.equals("org.apache.camel")) {
                        v = camelVersion;
                    }
                    if (v == null && g.equals("org.apache.camel.springboot")) {
                        v = camelVersion;
                    }
                    if (v == null && g.equals("org.springframework.boot")) {
                        v = springBootVersion;
                    }
                    if (v == null && (g.equals("io.quarkus") || g.equals("org.apache.camel.quarkus"))) {
                        v = quarkusVersion;
                    }
                    if (this.skipArtifact(g, a, v)) continue;
                    if (v != null) {
                        gavs.add(MavenGav.parseGav((String)(g + ":" + a + ":" + v)));
                        continue;
                    }
                    gavs.add(MavenGav.parseGav((String)(g + ":" + a)));
                }
                gavs.sort(this.mavenGavComparator());
                i = 0;
                int total = gavs.size();
                for (MavenGav gav : gavs) {
                    this.outputGav(gav, i, total);
                    ++i;
                }
            }
            File buildDir = new File(EXPORT_DIR);
            FileUtil.removeDir((File)buildDir);
        }
        return answer;
    }

    protected void outputGav(MavenGav gav, int index, int total) {
        if ("gav".equals(this.output)) {
            this.outPrinter().println(String.valueOf(gav));
        } else if ("maven".equals(this.output)) {
            this.outPrinter().println("<dependency>");
            this.outPrinter().printf("    <groupId>%s</groupId>%n", gav.getGroupId());
            this.outPrinter().printf("    <artifactId>%s</artifactId>%n", gav.getArtifactId());
            this.outPrinter().printf("    <version>%s</version>%n", gav.getVersion());
            this.outPrinter().println("</dependency>");
        } else if ("jbang".equals(this.output)) {
            if (index == 0) {
                this.outPrinter().println("//DEPS org.apache.camel:camel-bom:" + gav.getVersion() + "@pom");
            }
            if (gav.getGroupId().equals("org.apache.camel")) {
                gav.setVersion(null);
            }
            this.outPrinter().println("//DEPS " + String.valueOf(gav));
        }
    }

    @Override
    protected Integer doExport() throws Exception {
        File profile = new File("application.properties");
        if (profile.exists()) {
            CamelCaseOrderedProperties prop = new CamelCaseOrderedProperties();
            RuntimeUtil.loadProperties((Properties)prop, profile);
            if (this.runtime == null && prop.containsKey("camel.jbang.runtime")) {
                this.runtime = RuntimeType.fromValue(prop.getProperty("camel.jbang.runtime"));
            }
            if (this.gav == null) {
                this.gav = prop.getProperty("camel.jbang.gav");
            }
            this.javaVersion = prop.getProperty("camel.jbang.javaVersion", this.javaVersion);
            this.camelVersion = prop.getProperty("camel.jbang.camelVersion", this.camelVersion);
            this.kameletsVersion = prop.getProperty("camel.jbang.kameletsVersion", this.kameletsVersion);
            this.localKameletDir = prop.getProperty("camel.jbang.localKameletDir", this.localKameletDir);
            this.quarkusGroupId = prop.getProperty("camel.jbang.quarkusGroupId", this.quarkusGroupId);
            this.quarkusArtifactId = prop.getProperty("camel.jbang.quarkusArtifactId", this.quarkusArtifactId);
            this.quarkusVersion = prop.getProperty("camel.jbang.quarkusVersion", this.quarkusVersion);
            this.springBootVersion = prop.getProperty("camel.jbang.springBootVersion", this.springBootVersion);
        }
        this.exportDir = EXPORT_DIR;
        if (this.gav == null) {
            this.gav = "org.example.project:camel-jbang-dummy:1.0";
        }
        if (this.runtime == null) {
            this.runtime = RuntimeType.main;
        }
        switch (this.runtime) {
            case springBoot: {
                return this.export(new ExportSpringBoot(this.getMain()));
            }
            case quarkus: {
                return this.export(new ExportQuarkus(this.getMain()));
            }
            case main: {
                return this.export(new ExportCamelMain(this.getMain()));
            }
        }
        this.printer().printErr("Unknown runtime: " + String.valueOf((Object)this.runtime));
        return 1;
    }

    protected boolean skipArtifact(String groupId, String artifactId, String version) {
        if ("org.fusesource.jansi".equals(groupId)) {
            return true;
        }
        return "org.apache.logging.log4j".equals(groupId);
    }
}

