/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.jbang.core.commands;

import java.io.File;
import org.apache.camel.dsl.jbang.core.common.Printer;
import org.apache.camel.util.FileUtil;

public final class CommandHelper {
    private static final ThreadLocal<Printer> printerAssociation = new ThreadLocal();

    private CommandHelper() {
    }

    public static Printer getPrinter() {
        return printerAssociation.get();
    }

    public static void setPrinter(Printer out) {
        printerAssociation.set(out);
    }

    public static void cleanExportDir(String dir) {
        CommandHelper.cleanExportDir(dir, true);
    }

    public static void cleanExportDir(String dir, boolean keepHidden) {
        File target = new File(dir);
        File[] files = target.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!(!f.isDirectory() || keepHidden && f.isHidden())) {
                    FileUtil.removeDir((File)f);
                    continue;
                }
                if (!f.isFile() || keepHidden && f.isHidden()) continue;
                FileUtil.deleteFile((File)f);
            }
        }
    }

    public static class ReadConsoleTask
    implements Runnable {
        private final Runnable listener;

        public ReadConsoleTask(Runnable listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            System.console().readLine();
            this.listener.run();
        }
    }
}

