/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.plugins.javadoc.SystemUtils;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public final class StaleHelper {
    private StaleHelper() {
    }

    public static String getStaleData(Commandline cmd) throws MavenReportException {
        try {
            ArrayList<String> ignored = new ArrayList<String>();
            ArrayList<String> options = new ArrayList<String>();
            Path dir = cmd.getWorkingDirectory().toPath().toAbsolutePath().normalize();
            String[] args = cmd.getCommandline();
            Collections.addAll(options, args);
            for (String arg : args) {
                if (!arg.startsWith("@")) continue;
                String name = arg.substring(1);
                options.addAll(Files.readAllLines(dir.resolve(name), StandardCharsets.UTF_8));
                ignored.add(name);
            }
            ArrayList<CallSite> state = new ArrayList<CallSite>(options);
            boolean cp = false;
            boolean sp = false;
            for (String arg : options) {
                Path p;
                String s;
                if (cp) {
                    s = StaleHelper.unquote(arg);
                    for (String ps : s.split(File.pathSeparator)) {
                        p = dir.resolve(ps);
                        state.add((CallSite)((Object)(p + " = " + StaleHelper.lastmod(p))));
                    }
                } else if (sp) {
                    s = StaleHelper.unquote(arg);
                    for (String ps : s.split(File.pathSeparator)) {
                        p = dir.resolve(ps);
                        for (Path c : StaleHelper.walk(p)) {
                            if (!Files.isRegularFile(c, new LinkOption[0])) continue;
                            state.add((CallSite)((Object)(c + " = " + StaleHelper.lastmod(c))));
                        }
                        state.add((CallSite)((Object)(p + " = " + StaleHelper.lastmod(p))));
                    }
                }
                cp = "-classpath".equals(arg);
                sp = "-sourcepath".equals(arg);
            }
            for (Path p : StaleHelper.walk(dir)) {
                if (!Files.isRegularFile(p, new LinkOption[0]) || ignored.contains(p.getFileName().toString())) continue;
                state.add((CallSite)((Object)(p + " = " + StaleHelper.lastmod(p))));
            }
            return StringUtils.join(state.iterator(), (String)SystemUtils.LINE_SEPARATOR);
        }
        catch (Exception e) {
            throw new MavenReportException("Unable to compute stale date", e);
        }
    }

    public static void writeStaleData(Commandline cmd, Path path) throws MavenReportException {
        try {
            String curdata = StaleHelper.getStaleData(cmd);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            FileUtils.fileWrite((File)path.toFile(), null, (String)curdata);
        }
        catch (IOException e) {
            throw new MavenReportException("Error checking stale data", (Exception)e);
        }
    }

    private static Collection<Path> walk(Path dir) {
        ArrayList<Path> arrayList;
        block9: {
            DirectoryStream<Path> pathStream = Files.newDirectoryStream(dir);
            try {
                ArrayList<Path> paths = new ArrayList<Path>();
                for (Path p : pathStream) {
                    paths.add(p);
                }
                arrayList = paths;
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pathStream.close();
        }
        return arrayList;
    }

    private static String unquote(String s) {
        if (s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1).replaceAll("\\\\'", "'");
        }
        return s;
    }

    private static long lastmod(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

