/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.javadoc.JavadocArchiveConfiguration;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CamelJavadocJar
extends AbstractJavadocMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{DEBUG_JAVADOC_SCRIPT_NAME, "options", "packages", "argfile", "files"};
    @Parameter(defaultValue="${project.build.directory}/apidocstmp", required=true)
    protected File intermediateDirectory;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Deprecated
    @Parameter(property="destDir")
    private File destDir;
    @Parameter(property="project.build.directory")
    private String jarOutputDirectory;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(property="attach", defaultValue="true")
    private boolean attach;
    @Parameter
    private MavenArchiveConfiguration archive = new JavadocArchiveConfiguration(){
        {
            this.setForced(false);
        }
    };
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(defaultValue="false")
    private boolean useDefaultManifestFile;
    @Parameter(property="maven.javadoc.classifier", defaultValue="javadoc", required=true)
    private String classifier;

    @Override
    public void doExecute() throws MojoExecutionException {
        ArtifactHandler artifactHandler;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        try {
            Field f = AbstractJavadocMojo.class.getDeclaredField("additionalOptions");
            f.setAccessible(true);
            String[] additionalOptions = (String[])f.get((Object)this);
            if (additionalOptions == null || additionalOptions.length == 0) {
                additionalOptions = new String[]{"-notimestamp"};
            } else {
                ArrayList<String> l = new ArrayList<String>(Arrays.asList(additionalOptions));
                l.add("-notimestamp");
                additionalOptions = l.toArray(new String[0]);
            }
            f.set((Object)this, additionalOptions);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to set javadoc options", e);
        }
        File innerDestDir = this.destDir;
        if (innerDestDir == null) {
            innerDestDir = new File(this.getOutputDirectory());
        }
        if (!("pom".equalsIgnoreCase(this.project.getPackaging()) && this.isAggregator() || "java".equals((artifactHandler = this.project.getArtifact().getArtifactHandler()).getLanguage()))) {
            this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
            return;
        }
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException e) {
            this.failOnError("MavenReportException: Error while generating Javadoc", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.failOnError("RuntimeException: Error while generating Javadoc", e);
        }
        if (innerDestDir.exists()) {
            try {
                Path inputDir = innerDestDir.toPath();
                Path outputDir = this.intermediateDirectory.toPath();
                Files.createDirectories(outputDir, new FileAttribute[0]);
                TreeSet<Path> input = this.getAllRelativeFiles(inputDir);
                TreeSet<Path> output = this.getAllRelativeFiles(outputDir);
                output.removeAll(input);
                output.remove(Paths.get("META-INF", new String[0]));
                output.remove(Paths.get("META-INF/MANIFEST.MF", new String[0]));
                for (Path p : output) {
                    Files.delete(outputDir.resolve(p));
                }
                for (Path p : input) {
                    this.copy(inputDir.resolve(p), outputDir.resolve(p));
                }
                File outputFile = this.generateArchive(this.intermediateDirectory, this.finalName + "-" + this.getClassifier() + ".jar");
                if (!this.attach) {
                    this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
                } else {
                    this.projectHelper.attachArtifact(this.project, "javadoc", this.getClassifier(), outputFile);
                }
            }
            catch (ArchiverException e) {
                this.failOnError("ArchiverException: Error while creating archive", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.failOnError("IOException: Error while creating archive", e);
            }
            catch (RuntimeException e) {
                this.failOnError("RuntimeException: Error while creating archive", e);
            }
        }
    }

    void copy(Path in, Path out) throws IOException {
        if (Files.isDirectory(in, new LinkOption[0])) {
            Files.createDirectories(out, new FileAttribute[0]);
        } else if (Files.isRegularFile(in, new LinkOption[0])) {
            byte[] dataOut;
            byte[] dataIn = Files.readAllBytes(in);
            if (Files.isRegularFile(out, new LinkOption[0]) && Files.isReadable(out) && Arrays.equals(dataIn, dataOut = Files.readAllBytes(out))) {
                return;
            }
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    TreeSet<Path> getAllRelativeFiles(Path dir) throws IOException {
        try (Stream<Path> pathStream = Files.walk(dir, new FileVisitOption[0]);){
            TreeSet treeSet = pathStream.map(dir::relativize).collect(Collectors.toCollection(TreeSet::new));
            return treeSet;
        }
    }

    protected String getClassifier() {
        return this.classifier;
    }

    private File generateArchive(File javadocFiles, String jarFileName) throws ArchiverException, IOException {
        File javadocJar = new File(this.jarOutputDirectory, jarFileName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(javadocJar);
        File contentDirectory = javadocFiles;
        if (!contentDirectory.exists()) {
            this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
        } else {
            archiver.getArchiver().addDirectory(contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        }
        List resources = this.project.getBuild().getResources();
        for (Resource r : resources) {
            if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
            archiver.getArchiver().addDirectory(new File(r.getDirectory()));
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        if (this.archive.getManifestFile() == null) {
            try {
                Manifest manifest = archiver.getManifest(this.session, this.project, this.archive);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                manifest.write((OutputStream)baos);
                Path man = javadocFiles.toPath().resolve("META-INF/MANIFEST.MF");
                byte[] data = null;
                if (Files.isRegularFile(man, new LinkOption[0])) {
                    data = Files.readAllBytes(man);
                }
                if (!Arrays.equals(data, baos.toByteArray())) {
                    Files.createDirectories(man.getParent(), new FileAttribute[0]);
                    Files.copy(new ByteArrayInputStream(baos.toByteArray()), man, StandardCopyOption.REPLACE_EXISTING);
                }
                this.archive.setManifestFile(man.toFile());
            }
            catch (ManifestException e) {
                throw new ArchiverException("ManifestException: " + e.getMessage(), (Throwable)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new ArchiverException("DependencyResolutionRequiredException: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ManifestException e) {
            throw new ArchiverException("ManifestException: " + e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ArchiverException("DependencyResolutionRequiredException: " + e.getMessage(), (Throwable)e);
        }
        return javadocJar;
    }
}

