/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.java.joor;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.java.joor.Helper;
import org.apache.camel.dsl.support.ExtendedRouteBuilderLoaderSupport;
import org.apache.camel.language.joor.CamelJoorClassLoader;
import org.apache.camel.language.joor.CompilationUnit;
import org.apache.camel.language.joor.JavaJoorClassLoader;
import org.apache.camel.language.joor.MultiCompile;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.CompilePreProcessor;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed JavaRoutesBuilderLoader")
@RoutesLoader(value="java")
public class JavaRoutesBuilderLoader
extends ExtendedRouteBuilderLoaderSupport {
    public static final String EXTENSION = "java";
    private static final Logger LOG = LoggerFactory.getLogger(JavaRoutesBuilderLoader.class);
    private final ConcurrentMap<Collection<Resource>, CompilationUnit.Result> compiled = new ConcurrentHashMap<Collection<Resource>, CompilationUnit.Result>();
    private final Map<String, Resource> nameToResource = new HashMap<String, Resource>();
    private JavaJoorClassLoader classLoader;

    public JavaRoutesBuilderLoader() {
        super(EXTENSION);
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        CamelContext context = this.getCamelContext();
        if (context != null) {
            CompileStrategy cs;
            this.classLoader = (JavaJoorClassLoader)context.getClassResolver().getClassLoader("JavaJoorClassLoader");
            if (this.classLoader == null) {
                this.classLoader = new JavaJoorClassLoader();
                context.getClassResolver().addClassLoader((ClassLoader)this.classLoader);
            }
            if ((cs = (CompileStrategy)context.getCamelContextExtension().getContextPlugin(CompileStrategy.class)) != null && cs.getWorkDir() != null) {
                this.classLoader.setCompileDirectory(cs.getWorkDir());
            }
        }
    }

    public void preParseRoute(Resource resource) throws Exception {
        List<Resource> key = List.of(resource);
        this.preParseRoutes(key);
    }

    public void preParseRoutes(Collection<Resource> resources) throws Exception {
        CompilationUnit.Result result = (CompilationUnit.Result)this.compiled.get(resources);
        if (result == null) {
            result = this.compileResources(resources);
            this.compiled.put(resources, result);
        }
    }

    protected RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        Collection<RoutesBuilder> answer;
        List<Resource> key = List.of(resource);
        CompilationUnit.Result result = (CompilationUnit.Result)this.compiled.get(key);
        if (result == null) {
            result = this.compileResources(key);
            this.compiled.put(key, result);
        }
        if ((answer = this.doLoadRoutesBuilders(key)).size() == 1) {
            RoutesBuilder builder = answer.iterator().next();
            return (RouteBuilder)builder;
        }
        return super.doLoadRouteBuilder(resource);
    }

    protected Collection<RoutesBuilder> doLoadRoutesBuilders(Collection<Resource> resources) throws Exception {
        ArrayList<RoutesBuilder> answer = new ArrayList<RoutesBuilder>();
        CompilationUnit.Result result = (CompilationUnit.Result)this.compiled.remove(resources);
        if (result == null) {
            result = this.compileResources(resources);
        }
        for (String className : result.getClassNames()) {
            Object obj = null;
            Class clazz = result.getClass(className);
            if (clazz != null) {
                BindToRegistry bir = clazz.getAnnotation(BindToRegistry.class);
                boolean skip = clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isPrivate(clazz.getModifiers()) || bir != null && bir.lazy();
                boolean ctr = ObjectHelper.hasDefaultNoArgConstructor((Class)clazz);
                if (ctr && !skip) {
                    try {
                        obj = this.getCamelContext().getInjector().newInstance(clazz);
                        if (obj != null) {
                            LOG.debug("Compiled: {} -> {}", (Object)className, obj);
                            CamelContextAware.trySetCamelContext((Object)obj, (CamelContext)this.getCamelContext());
                            ResourceAware.trySetResource((Object)obj, (Resource)this.nameToResource.remove(className));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException("Cannot create instance of class: " + className, (Throwable)e);
                    }
                }
            }
            for (CompilePostProcessor pre : this.getCompilePostProcessors()) {
                byte[] byteCode = result.getByteCode(className);
                pre.postCompile(this.getCamelContext(), className, clazz, byteCode, obj);
            }
            if (!(obj instanceof RouteBuilder)) continue;
            RouteBuilder builder = (RouteBuilder)obj;
            answer.add((RoutesBuilder)builder);
        }
        return answer;
    }

    protected CompilationUnit.Result compileResources(Collection<Resource> resources) throws Exception {
        LOG.debug("Loading .java resources from: {}", resources);
        CompilationUnit unit = CompilationUnit.input();
        for (Resource resource : resources) {
            InputStream is = this.resourceInputStream(resource);
            try {
                if (is == null) {
                    throw new FileNotFoundException(resource.getLocation());
                }
                String content = IOHelper.loadText((InputStream)is);
                String name = Helper.determineName(resource, content);
                for (CompilePreProcessor pre : this.getCompilePreProcessors()) {
                    pre.preCompile(this.getCamelContext(), name, content);
                }
                unit.addClass(name, content);
                this.classLoader.removeClass(name);
                this.nameToResource.put(name, resource);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        ClassLoader parent = this.resolveParentClassLoader();
        if (parent instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)parent;
            CamelJoorClassLoader cl = new CamelJoorClassLoader(ucl, this.getCamelContext());
            unit.withClassLoader((ClassLoader)cl);
        }
        if (LOG.isDebugEnabled()) {
            String names = String.join((CharSequence)", ", unit.getInput().keySet());
            LOG.debug("Compiling: {}", (Object)names);
        }
        CompilationUnit.Result result = MultiCompile.compileUnit((CompilationUnit)unit);
        if (this.getCamelContext().hasService(RouteWatcherReloadStrategy.class) != null) {
            this.getCamelContext().getRegistry().bind("RouteWatcherReloadResources", this.nameToResource.values());
        }
        for (String className : result.getClassNames()) {
            Class clazz = result.getClass(className);
            byte[] code = result.getByteCode(className);
            this.classLoader.addClass(className, clazz, code);
        }
        return result;
    }

    protected ClassLoader resolveParentClassLoader() {
        return MethodHandles.lookup().lookupClass().getClassLoader();
    }

    protected void doShutdown() throws Exception {
        this.compiled.clear();
        this.nameToResource.clear();
    }
}

