/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.java.joor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;

public final class Helper {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s+([a-zA-Z][.\\w]*)\\s*;.*$", 8);
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^import\\s+([a-zA-Z][.\\w]*)\\s*;", 8);

    private Helper() {
    }

    public static String determineName(Resource resource, String content) {
        String loc = resource.getLocation();
        String scheme = ResourceHelper.getScheme((String)loc);
        if (scheme != null) {
            loc = loc.substring(scheme.length());
        }
        String name = FileUtil.onlyName((String)loc, (boolean)true);
        Matcher matcher = PACKAGE_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) + "." + name : name;
    }

    public static List<String> determineImports(String content) {
        ArrayList<String> answer = new ArrayList<String>();
        Matcher matcher = IMPORT_PATTERN.matcher(content);
        while (matcher.find()) {
            String imp = matcher.group(1);
            imp = imp.trim();
            answer.add(imp);
        }
        return answer;
    }
}

