/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import io.iron.ironmq.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.ironmq.GsonUtil;
import org.apache.camel.component.ironmq.IronMQConfiguration;
import org.apache.camel.component.ironmq.IronMQEndpoint;
import org.apache.camel.support.DefaultProducer;

public class IronMQProducer
extends DefaultProducer {
    private final Queue ironQueue;

    public IronMQProducer(IronMQEndpoint endpoint, Queue ironQueue) {
        super((Endpoint)endpoint);
        this.ironQueue = ironQueue;
    }

    public void process(Exchange exchange) throws Exception {
        IronMQConfiguration configuration = this.getEndpoint().getConfiguration();
        if ("CamelIronMQClearQueue".equals(exchange.getIn().getHeader("CamelIronMQOperation", String.class))) {
            this.ironQueue.clear();
        } else {
            Object messageId = null;
            Object body = exchange.getIn().getBody();
            if (body instanceof String[]) {
                messageId = this.ironQueue.pushMessages((String[])body, (long)configuration.getVisibilityDelay());
            } else if (body instanceof String) {
                if (configuration.isPreserveHeaders()) {
                    body = GsonUtil.getBodyFromMessage(exchange.getIn());
                }
                messageId = this.ironQueue.push((String)body, (long)configuration.getVisibilityDelay());
            } else {
                throw new InvalidPayloadException(exchange, String.class);
            }
            this.log.trace("Send request [{}] from exchange [{}]...", body, (Object)exchange);
            this.log.trace("Received messageId [{}]", messageId);
            Message message = this.getMessageForResponse(exchange);
            message.setHeader("CamelIronMQMessageId", messageId);
        }
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    public IronMQEndpoint getEndpoint() {
        return (IronMQEndpoint)super.getEndpoint();
    }
}

