/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import io.nessus.ipfs.client.DefaultIPFSClient;
import io.nessus.ipfs.client.IPFSClient;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ipfs.IPFSConfiguration;
import org.apache.camel.component.ipfs.IPFSEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="ipfs")
public class IPFSComponent
extends DefaultComponent {
    @Metadata(description="The ipfs host", defaultValue="127.0.0.1")
    private String ipfsHost = "127.0.0.1";
    @Metadata(description="The ipfs port", defaultValue="5001")
    private int ipfsPort = 5001;
    private IPFSClient client;

    public String getIpfsHost() {
        return this.ipfsHost;
    }

    public void setIpfsHost(String ipfsHost) {
        this.ipfsHost = ipfsHost;
    }

    public int getIpfsPort() {
        return this.ipfsPort;
    }

    public void setIpfsPort(int ipfsPort) {
        this.ipfsPort = ipfsPort;
    }

    protected Endpoint createEndpoint(String urispec, String remaining, Map<String, Object> parameters) throws Exception {
        IPFSConfiguration config = new IPFSConfiguration();
        IPFSEndpoint endpoint = new IPFSEndpoint(urispec, this, config);
        this.setProperties((Endpoint)endpoint, parameters);
        String cmd = remaining;
        config.setIpfsCmd(cmd);
        return endpoint;
    }

    public IPFSClient getIPFSClient() {
        if (this.client == null) {
            this.client = new DefaultIPFSClient(this.ipfsHost, Integer.valueOf(this.ipfsPort));
        }
        return this.client;
    }
}

