/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.ipfs.client.IPFSClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ipfs.IPFSComponent;
import org.apache.camel.component.ipfs.IPFSConfiguration;
import org.apache.camel.component.ipfs.IPFSProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="ipfs", title="IPFS", syntax="ipfs:host:port/cmd", producerOnly=true, label="file,ipfs")
public class IPFSEndpoint
extends DefaultEndpoint {
    static long defaultTimeout = 10000L;
    @UriParam
    private final IPFSConfiguration configuration;

    public IPFSEndpoint(String uri, IPFSComponent component, IPFSConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public IPFSComponent getComponent() {
        return (IPFSComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        return new IPFSProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    IPFSConfiguration getConfiguration() {
        return this.configuration;
    }

    IPFSConfiguration.IPFSCommand getCommand() {
        String cmd = this.configuration.getIpfsCmd();
        try {
            return IPFSConfiguration.IPFSCommand.valueOf(cmd);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported command: " + cmd);
        }
    }

    String ipfsVersion() throws IOException {
        return this.ipfs().version();
    }

    List<String> ipfsAdd(Path path) throws IOException {
        List cids = this.ipfs().add(path);
        return cids.stream().map(mh -> mh.toBase58()).collect(Collectors.toList());
    }

    InputStream ipfsCat(String cid) throws IOException, TimeoutException {
        Multihash mhash = Multihash.fromBase58((String)cid);
        Future future = this.ipfs().cat(mhash);
        try {
            return (InputStream)future.get(defaultTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException("Cannot obtain: " + cid, ex);
        }
    }

    Path ipfsGet(String cid, Path outdir) throws IOException, TimeoutException {
        Multihash mhash = Multihash.fromBase58((String)cid);
        Future future = this.ipfs().get(mhash, outdir);
        try {
            return (Path)future.get(defaultTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException("Cannot obtain: " + cid, ex);
        }
    }

    private IPFSClient ipfs() {
        return this.getComponent().getIPFSClient();
    }
}

