/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.component.ipfs.IPFSComponent;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class IPFSConfiguration {
    @UriPath(description="The ipfs command")
    private String ipfsCmd;
    @UriParam(description="The ipfs output directory")
    private Path outdir;
    private String ipfsHost = "127.0.0.1";
    private int ipfsPort = 5001;

    public IPFSConfiguration(IPFSComponent component) {
        ObjectHelper.notNull((Object)((Object)component), (String)"component");
    }

    public String getIpfsCmd() {
        return this.ipfsCmd;
    }

    public void setIpfsCmd(String cmd) {
        this.ipfsCmd = cmd;
    }

    public String getIpfsHost() {
        return this.ipfsHost;
    }

    public void setIpfsHost(String ipfsHost) {
        this.ipfsHost = ipfsHost;
    }

    public int getIpfsPort() {
        return this.ipfsPort;
    }

    public void setIpfsPort(int ipfsPort) {
        this.ipfsPort = ipfsPort;
    }

    public Path getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        this.outdir = Paths.get(outdir, new String[0]);
    }

    public static enum IPFSCommand {
        add,
        cat,
        get,
        version;

    }
}

