/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded;

import java.util.HashSet;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.InfinispanEventProcessor;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedEventListeners;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedUtil;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.query.Search;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;

public class InfinispanEmbeddedConsumer
extends InfinispanConsumer<EmbeddedCacheManager, InfinispanEmbeddedManager, InfinispanEmbeddedConfiguration> {
    private Service handler;

    public InfinispanEmbeddedConsumer(InfinispanEndpoint endpoint, Processor processor, String cacheName, InfinispanEmbeddedManager manager, InfinispanEmbeddedConfiguration configuration) {
        super(endpoint, processor, cacheName, (InfinispanManager)manager, (InfinispanConfiguration)configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handler = ((InfinispanEmbeddedConfiguration)this.getConfiguration()).hasQueryBuilder() ? new ContinuousQueryHandler() : new ConsumerHandler();
        ServiceHelper.startService((Object)this.handler);
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.handler);
    }

    private class ContinuousQueryHandler
    extends ServiceSupport
    implements ContinuousQueryListener<Object, Object> {
        private ContinuousQuery<Object, Object> continuousQuery;

        private ContinuousQueryHandler() {
        }

        public void resultJoining(Object key, Object value) {
            InfinispanEmbeddedConsumer.this.processEvent("CacheEntryJoining", InfinispanEmbeddedConsumer.this.cacheName, key, value, null);
        }

        public void resultUpdated(Object key, Object value) {
            InfinispanEmbeddedConsumer.this.processEvent("CacheEntryUpdated", InfinispanEmbeddedConsumer.this.cacheName, key, value, null);
        }

        public void resultLeaving(Object key) {
            InfinispanEmbeddedConsumer.this.processEvent("CacheEntryLeaving", InfinispanEmbeddedConsumer.this.cacheName, key, null, null);
        }

        public void doStart() {
            Cache remoteCache = (Cache)InfinispanEmbeddedConsumer.this.getCache(Cache.class);
            Query<?> query = InfinispanEmbeddedUtil.buildQuery(((InfinispanEmbeddedConfiguration)InfinispanEmbeddedConsumer.this.getConfiguration()).getQueryBuilder(), (Cache<Object, Object>)remoteCache);
            this.continuousQuery = Search.getContinuousQuery((Cache)remoteCache);
            this.continuousQuery.addContinuousQueryListener(query, (ContinuousQueryListener)this);
        }

        public void doStop() {
            if (this.continuousQuery != null) {
                this.continuousQuery.removeAllListeners();
            }
        }
    }

    private class ConsumerHandler
    extends ServiceSupport {
        private InfinispanEventListener<Event.Type> listener;

        private ConsumerHandler() {
        }

        public void doStart() {
            Cache cache = (Cache)InfinispanEmbeddedConsumer.this.getCache(Cache.class);
            InfinispanEmbeddedConfiguration configuration = (InfinispanEmbeddedConfiguration)InfinispanEmbeddedConsumer.this.getConfiguration();
            this.listener = configuration.getCustomListener();
            if (this.listener == null) {
                HashSet<Event.Type> events = new HashSet<Event.Type>();
                if (configuration.getEventTypes() != null) {
                    String eventTypes = configuration.getEventTypes();
                    for (String event : eventTypes.split(",")) {
                        events.add(Event.Type.valueOf((String)event));
                    }
                }
                this.listener = configuration.isClusteredListener() ? (configuration.isSync() ? new InfinispanEmbeddedEventListeners.ClusteredSync(events) : new InfinispanEmbeddedEventListeners.ClusteredAsync(events)) : (configuration.isSync() ? new InfinispanEmbeddedEventListeners.LocalSync(events) : new InfinispanEmbeddedEventListeners.LocalAsync(events));
            }
            this.listener.setCacheName(cache.getName());
            this.listener.setEventProcessor((InfinispanEventProcessor)InfinispanEmbeddedConsumer.this);
            cache.addListener(this.listener);
        }

        public void doStop() {
            ((Cache)InfinispanEmbeddedConsumer.this.getCache(Cache.class)).removeListener(this.listener);
        }
    }
}

