/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.embedded.cluster;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.cluster.InfinispanClusterView;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedConfiguration;
import org.apache.camel.component.infinispan.embedded.InfinispanEmbeddedManager;
import org.apache.camel.component.infinispan.embedded.cluster.InfinispanEmbeddedClusterConfiguration;
import org.apache.camel.component.infinispan.embedded.cluster.InfinispanEmbeddedClusterService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.Predicates;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.util.function.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanEmbeddedClusterView
extends InfinispanClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanEmbeddedClusterService.class);
    private final InfinispanEmbeddedClusterConfiguration configuration;
    private final InfinispanEmbeddedManager manager;
    private final InfinispanClusterView.LocalMember localMember;
    private final LeadershipService leadership;
    private Cache<String, String> cache;

    protected InfinispanEmbeddedClusterView(InfinispanEmbeddedClusterService cluster, InfinispanEmbeddedClusterConfiguration configuration, String namespace) {
        super((CamelClusterService)cluster, namespace);
        this.configuration = configuration;
        this.manager = new InfinispanEmbeddedManager((InfinispanEmbeddedConfiguration)this.configuration.getConfiguration());
        this.leadership = new LeadershipService();
        this.localMember = new InfinispanClusterView.LocalMember((InfinispanClusterView)this, cluster.getId());
    }

    public void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)((Object)this.manager));
        this.cache = (Cache)this.manager.getCache(this.getNamespace(), Cache.class);
        ServiceHelper.startService((Object)((Object)this.leadership));
    }

    public void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)((Object)this.leadership));
        ServiceHelper.stopService((Object)((Object)this.manager));
        this.cache = null;
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return this.cache != null ? (List)this.cache.keySet().stream().filter(Predicates.negate("__camel_leader"::equals)).map((SerializableFunction & Serializable)x$0 -> new InfinispanClusterView.ClusterMember((InfinispanClusterView)this, x$0)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public Optional<CamelClusterMember> getLeader() {
        if (this.cache == null) {
            return Optional.empty();
        }
        String id = (String)this.cache.get((Object)"__camel_leader");
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(new InfinispanClusterView.ClusterMember((InfinispanClusterView)this, id));
    }

    protected boolean isLeader(String id) {
        if (this.cache == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        String key = "__camel_leader";
        String val = (String)this.cache.get((Object)"__camel_leader");
        return Objects.equals(id, val);
    }

    @Listener(clustered=true, sync=false)
    private final class LeadershipService
    extends ServiceSupport {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private ScheduledExecutorService executorService;

        LeadershipService() {
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.running.set(true);
            this.executorService = InfinispanUtil.newSingleThreadScheduledExecutor((CamelContext)InfinispanEmbeddedClusterView.this.getCamelContext(), (Object)((Object)this), (String)InfinispanEmbeddedClusterView.this.getLocalMember().getId());
            InfinispanEmbeddedClusterView.this.cache.put((Object)InfinispanEmbeddedClusterView.this.getLocalMember().getId(), (Object)"false", InfinispanEmbeddedClusterView.this.configuration.getLifespan(), InfinispanEmbeddedClusterView.this.configuration.getLifespanTimeUnit());
            InfinispanEmbeddedClusterView.this.cache.addListener((Object)this);
            this.executorService.scheduleAtFixedRate(this::run, 0L, InfinispanEmbeddedClusterView.this.configuration.getLifespan() / 2L, InfinispanEmbeddedClusterView.this.configuration.getLifespanTimeUnit());
        }

        protected void doStop() throws Exception {
            super.doStop();
            this.running.set(false);
            if (InfinispanEmbeddedClusterView.this.cache != null) {
                InfinispanEmbeddedClusterView.this.cache.removeListener((Object)this);
            }
            InfinispanEmbeddedClusterView.this.getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            if (InfinispanEmbeddedClusterView.this.cache != null) {
                InfinispanEmbeddedClusterView.this.cache.remove((Object)"__camel_leader", (Object)InfinispanEmbeddedClusterView.this.getClusterService().getId());
                LOGGER.info("Removing local member, key={}", (Object)InfinispanEmbeddedClusterView.this.getLocalMember().getId());
                InfinispanEmbeddedClusterView.this.cache.remove((Object)InfinispanEmbeddedClusterView.this.getLocalMember().getId());
            }
        }

        private boolean isLeader() {
            return InfinispanEmbeddedClusterView.this.getLocalMember().isLeader();
        }

        private void setLeader(boolean leader) {
            ((InfinispanClusterView.LocalMember)InfinispanEmbeddedClusterView.this.getLocalMember()).setLeader(leader);
        }

        private synchronized void run() {
            if (!this.running.get()) {
                return;
            }
            String leaderKey = "__camel_leader";
            String localId = InfinispanEmbeddedClusterView.this.getLocalMember().getId();
            if (this.isLeader()) {
                LOGGER.debug("Lock refresh key={}, id{}", (Object)"__camel_leader", (Object)localId);
                if (!InfinispanEmbeddedClusterView.this.cache.replace((Object)"__camel_leader", (Object)InfinispanEmbeddedClusterView.this.getClusterService().getId(), (Object)InfinispanEmbeddedClusterView.this.getClusterService().getId(), InfinispanEmbeddedClusterView.this.configuration.getLifespan(), InfinispanEmbeddedClusterView.this.configuration.getLifespanTimeUnit())) {
                    LOGGER.debug("Failed to refresh the lock key={}, id={}", (Object)"__camel_leader", (Object)localId);
                    this.setLeader(false);
                }
            }
            if (!this.isLeader()) {
                LOGGER.debug("Try to acquire lock key={}, id={}", (Object)"__camel_leader", (Object)localId);
                Object result = InfinispanEmbeddedClusterView.this.cache.putIfAbsent((Object)"__camel_leader", (Object)InfinispanEmbeddedClusterView.this.getClusterService().getId(), InfinispanEmbeddedClusterView.this.configuration.getLifespan(), InfinispanEmbeddedClusterView.this.configuration.getLifespanTimeUnit());
                if (result == null) {
                    LOGGER.debug("Lock acquired key={}, id={}", (Object)"__camel_leader", (Object)localId);
                    this.setLeader(true);
                } else if (Objects.equals(InfinispanEmbeddedClusterView.this.getClusterService().getId(), result) && !this.isLeader()) {
                    LOGGER.debug("Lock resumed key={}, id={}", (Object)"__camel_leader", (Object)localId);
                    this.setLeader(true);
                } else {
                    LOGGER.debug("Failed to acquire the lock key={}, id={}", (Object)"__camel_leader", (Object)localId);
                    this.setLeader(false);
                }
            }
            InfinispanEmbeddedClusterView.this.cache.put((Object)InfinispanEmbeddedClusterView.this.getLocalMember().getId(), (Object)(this.isLeader() ? "true" : "false"), InfinispanEmbeddedClusterView.this.configuration.getLifespan(), InfinispanEmbeddedClusterView.this.configuration.getLifespanTimeUnit());
        }

        @CacheEntryRemoved
        public void onCacheEntryRemoved(CacheEntryEvent<Object, Object> event) {
            if (!this.running.get()) {
                return;
            }
            LOGGER.debug("onCacheEntryRemoved id={}, lock-key={}, event-key={}", new Object[]{InfinispanEmbeddedClusterView.this.getLocalMember().getId(), "__camel_leader", event.getKey()});
            if (Objects.equals("__camel_leader", event.getKey())) {
                this.executorService.execute(this::run);
            }
        }

        @CacheEntryExpired
        public void onCacheEntryExpired(CacheEntryEvent<Object, Object> event) {
            if (!this.running.get()) {
                return;
            }
            LOGGER.debug("onCacheEntryExpired id={}, lock-key={}, event-key={}", new Object[]{InfinispanEmbeddedClusterView.this.getLocalMember().getId(), "__camel_leader", event.getKey()});
            if (Objects.equals("__camel_leader", event.getKey())) {
                this.executorService.execute(this::run);
            }
        }
    }
}

