/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;
import org.infinispan.commons.api.BasicCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public interface InfinispanIdempotentRepositoryTestSupport {
    public IdempotentRepository getIdempotentRepository();

    public BasicCache<Object, Object> getCache();

    public MockEndpoint getMockEndpoint(String var1);

    public ProducerTemplate template();

    @Test
    default public void addsNewKeysToCache() {
        Assertions.assertTrue((boolean)this.getIdempotentRepository().add("One"));
        Assertions.assertTrue((boolean)this.getIdempotentRepository().add("Two"));
        Assertions.assertTrue((boolean)this.getCache().containsKey((Object)"One"));
        Assertions.assertTrue((boolean)this.getCache().containsKey((Object)"Two"));
    }

    @Test
    default public void skipsAddingSecondTimeTheSameKey() {
        Assertions.assertTrue((boolean)this.getIdempotentRepository().add("One"));
        Assertions.assertFalse((boolean)this.getIdempotentRepository().add("One"));
    }

    @Test
    default public void containsPreviouslyAddedKey() {
        Assertions.assertFalse((boolean)this.getIdempotentRepository().contains("One"));
        this.getIdempotentRepository().add("One");
        Assertions.assertTrue((boolean)this.getIdempotentRepository().contains("One"));
    }

    @Test
    default public void removesAnExistingKey() {
        this.getIdempotentRepository().add("One");
        Assertions.assertTrue((boolean)this.getIdempotentRepository().remove("One"));
        Assertions.assertFalse((boolean)this.getIdempotentRepository().contains("One"));
    }

    @Test
    default public void doesntRemoveMissingKey() {
        Assertions.assertFalse((boolean)this.getIdempotentRepository().remove("One"));
    }

    @Test
    default public void clearCache() {
        Assertions.assertTrue((boolean)this.getIdempotentRepository().add("One"));
        Assertions.assertTrue((boolean)this.getIdempotentRepository().add("Two"));
        Assertions.assertTrue((boolean)this.getCache().containsKey((Object)"One"));
        Assertions.assertTrue((boolean)this.getCache().containsKey((Object)"Two"));
        this.getIdempotentRepository().clear();
        Assertions.assertFalse((boolean)this.getCache().containsKey((Object)"One"));
        Assertions.assertFalse((boolean)this.getCache().containsKey((Object)"Two"));
    }

    @Test
    default public void producerQueryOperationWithoutQueryBuilder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        String messageId = UUID.randomUUID().toString();
        IntStream.range(0, 10).forEach(i -> this.template().sendBodyAndHeader("direct:start", (Object)("message-" + i), "MessageID", (Object)messageId));
        mock.assertIsSatisfied();
    }
}

