/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.events;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.ClusterGroupExpression;
import org.apache.camel.component.ignite.events.IgniteEventsComponent;
import org.apache.camel.component.ignite.events.IgniteEventsConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.events.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-events", title="Ignite Events", syntax="ignite-events:endpointId", category={Category.MESSAGING, Category.EVENTBUS}, consumerOnly=true)
public class IgniteEventsEndpoint
extends AbstractIgniteEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(IgniteEventsEndpoint.class);
    @UriPath
    private String endpointId;
    @UriParam(label="consumer", defaultValue="EVTS_ALL")
    private String events = "EVTS_ALL";
    @UriParam(label="consumer")
    private ClusterGroupExpression clusterGroupExpression;

    public IgniteEventsEndpoint(String uri, String remaining, Map<String, Object> parameters, IgniteEventsComponent igniteComponent) {
        super(uri, (Component)igniteComponent);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The Ignite Events endpoint does not support producers.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        IgniteEvents events = this.createIgniteEvents();
        IgniteEventsConsumer consumer = new IgniteEventsConsumer(this, processor, events);
        this.configureConsumer((Consumer)consumer);
        LOG.info("Created Ignite Events consumer for event types: {}.", (Object)events);
        return consumer;
    }

    private IgniteEvents createIgniteEvents() {
        IgniteEvents events;
        Ignite ignite = this.ignite();
        if (this.clusterGroupExpression == null) {
            LOG.info("Ignite Events endpoint for event types {} using no Cluster Group.", (Object)this.events);
            events = ignite.events();
        } else {
            ClusterGroup group = this.clusterGroupExpression.getClusterGroup(ignite);
            LOG.info("Ignite Events endpoint for event types {} using Cluster Group: {}.", (Object)this.events, (Object)group);
            events = ignite.events(group);
        }
        return events;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEvents() {
        return this.events;
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public List<Integer> getEventsAsIds() {
        ArrayList<Integer> answer = new ArrayList<Integer>();
        if (this.events.equals("EVTS_ALL")) {
            int[] nArray = EventType.EVTS_ALL;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer eventType = nArray[i];
                answer.add(eventType);
            }
        } else {
            Field[] fields;
            HashSet<String> requestedEvents = new HashSet<String>(Arrays.asList(this.events.toUpperCase().split(",")));
            for (Field field : fields = EventType.class.getDeclaredFields()) {
                if (!requestedEvents.contains(field.getName())) continue;
                try {
                    answer.add(field.getInt(null));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Problem while resolving event type. See stacktrace.", e);
                }
            }
        }
        return answer;
    }

    public ClusterGroupExpression getClusterGroupExpression() {
        return this.clusterGroupExpression;
    }

    public void setClusterGroupExpression(ClusterGroupExpression clusterGroupExpression) {
        this.clusterGroupExpression = clusterGroupExpression;
    }
}

