/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.idgen;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.IgniteComponent;
import org.apache.camel.component.ignite.idgen.IgniteIdGenComponent;
import org.apache.camel.component.ignite.idgen.IgniteIdGenOperation;
import org.apache.camel.component.ignite.idgen.IgniteIdGenProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.ignite.IgniteAtomicSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="ignite-idgen", title="Ignite ID Generator", syntax="ignite-idgen:[name]", label="nosql,cache,compute", producerOnly=true)
public class IgniteIdGenEndpoint
extends AbstractIgniteEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(IgniteIdGenEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam(label="producer")
    private Integer batchSize;
    @UriParam(label="producer", defaultValue="0")
    private Long initialValue = 0L;
    @UriParam(label="producer")
    private IgniteIdGenOperation operation;

    @Deprecated
    public IgniteIdGenEndpoint(String endpointUri, URI remainingUri, Map<String, Object> parameters, IgniteComponent igniteComponent) throws Exception {
        super(endpointUri, (Component)igniteComponent);
        this.name = remainingUri.getHost();
        ObjectHelper.notNull((Object)this.name, (String)"ID Generator name");
    }

    public IgniteIdGenEndpoint(String endpointUri, String remaining, Map<String, Object> parameters, IgniteIdGenComponent igniteComponent) throws Exception {
        super(endpointUri, (Component)igniteComponent);
        this.name = remaining;
        ObjectHelper.notNull((Object)this.name, (String)"ID Generator name");
    }

    public Producer createProducer() throws Exception {
        IgniteAtomicSequence atomicSeq = this.ignite().atomicSequence(this.name, this.initialValue.longValue(), false);
        if (atomicSeq == null) {
            atomicSeq = this.ignite().atomicSequence(this.name, this.initialValue.longValue(), true);
            LOG.info("Created AtomicSequence of ID Generator with name {}.", (Object)this.name);
        }
        if (this.batchSize != null) {
            atomicSeq.batchSize(this.batchSize.intValue());
        }
        return new IgniteIdGenProducer(this, atomicSeq);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The Ignite Id Generator endpoint doesn't support consumers.");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Long initialValue) {
        this.initialValue = initialValue;
    }

    public IgniteIdGenOperation getOperation() {
        return this.operation;
    }

    public void setOperation(IgniteIdGenOperation operation) {
        this.operation = operation;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }
}

