/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.idgen;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.idgen.IgniteIdGenEndpoint;
import org.apache.camel.component.ignite.idgen.IgniteIdGenOperation;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.ignite.IgniteAtomicSequence;

public class IgniteIdGenProducer
extends DefaultAsyncProducer {
    private IgniteIdGenEndpoint endpoint;
    private IgniteAtomicSequence atomicSeq;

    public IgniteIdGenProducer(IgniteIdGenEndpoint endpoint, IgniteAtomicSequence atomicSeq) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.atomicSeq = atomicSeq;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders((Message)in, (Message)out, (boolean)true);
        Long id = (Long)in.getBody(Long.class);
        switch (this.idGenOperationFor(exchange)) {
            case ADD_AND_GET: {
                out.setBody((Object)this.atomicSeq.addAndGet(id.longValue()));
                break;
            }
            case GET: {
                out.setBody((Object)this.atomicSeq.get());
                break;
            }
            case GET_AND_ADD: {
                out.setBody((Object)this.atomicSeq.getAndAdd(id.longValue()));
                break;
            }
            case GET_AND_INCREMENT: {
                out.setBody((Object)this.atomicSeq.getAndIncrement());
                break;
            }
            case INCREMENT_AND_GET: {
                out.setBody((Object)this.atomicSeq.incrementAndGet());
                break;
            }
            default: {
                exchange.setException((Throwable)new UnsupportedOperationException("Operation not supported by Ignite ID Generator producer."));
                return true;
            }
        }
        return true;
    }

    private IgniteIdGenOperation idGenOperationFor(Exchange exchange) {
        return (IgniteIdGenOperation)((Object)exchange.getIn().getHeader("CamelIgniteIdGenOperation", (Object)this.endpoint.getOperation(), IgniteIdGenOperation.class));
    }
}

