/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.cache;

import java.net.URI;
import java.util.Map;
import javax.cache.Cache;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.IgniteComponent;
import org.apache.camel.component.ignite.cache.IgniteCacheContinuousQueryConsumer;
import org.apache.camel.component.ignite.cache.IgniteCacheOperation;
import org.apache.camel.component.ignite.cache.IgniteCacheProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;

@UriEndpoint(scheme="ignite:cache", title="Ignite Cache", syntax="ignite:cache:[cacheName]", label="nosql,cache,compute", consumerClass=IgniteCacheContinuousQueryConsumer.class)
public class IgniteCacheEndpoint
extends AbstractIgniteEndpoint {
    @UriParam
    @Metadata(required="true")
    private String cacheName;
    @UriParam
    private IgniteCacheOperation operation;
    @UriParam
    private boolean failIfInexistentCache;
    @UriParam
    private CachePeekMode cachePeekMode = CachePeekMode.ALL;
    @UriParam
    private Query<Cache.Entry<Object, Object>> query;
    @UriParam
    private CacheEntryEventSerializableFilter<Object, Object> remoteFilter;
    @UriParam
    private boolean oneExchangePerUpdate = true;
    @UriParam
    private boolean fireExistingQueryResults;
    @UriParam
    private boolean autoUnsubscribe = true;
    @UriParam
    private int pageSize = 1;
    @UriParam
    private long timeInterval = 0L;

    public IgniteCacheEndpoint(String endpointUri, URI remainingUri, Map<String, Object> parameters, IgniteComponent igniteComponent) {
        super(endpointUri, (Component)igniteComponent);
        this.cacheName = remainingUri.getHost();
    }

    public Producer createProducer() throws Exception {
        return new IgniteCacheProducer(this, this.obtainCache());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new IgniteCacheContinuousQueryConsumer(this, processor, this.obtainCache());
    }

    private IgniteCache<Object, Object> obtainCache() throws CamelException {
        IgniteCache cache = this.ignite().cache(this.cacheName);
        if (cache == null) {
            if (this.failIfInexistentCache) {
                throw new CamelException(String.format("Ignite cache %s doesn't exist, and failIfInexistentCache is true", this.cacheName));
            }
            cache = this.ignite().createCache(this.cacheName);
        }
        return cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public IgniteCacheOperation getOperation() {
        return this.operation;
    }

    public void setOperation(IgniteCacheOperation operation) {
        this.operation = operation;
    }

    public boolean isFailIfInexistentCache() {
        return this.failIfInexistentCache;
    }

    public void setFailIfInexistentCache(boolean failIfInexistentCache) {
        this.failIfInexistentCache = failIfInexistentCache;
    }

    public CachePeekMode getCachePeekMode() {
        return this.cachePeekMode;
    }

    public void setCachePeekMode(CachePeekMode cachePeekMode) {
        this.cachePeekMode = cachePeekMode;
    }

    public Query<Cache.Entry<Object, Object>> getQuery() {
        return this.query;
    }

    public void setQuery(Query<Cache.Entry<Object, Object>> query) {
        this.query = query;
    }

    public CacheEntryEventSerializableFilter<Object, Object> getRemoteFilter() {
        return this.remoteFilter;
    }

    public void setRemoteFilter(CacheEntryEventSerializableFilter<Object, Object> remoteFilter) {
        this.remoteFilter = remoteFilter;
    }

    public boolean isOneExchangePerUpdate() {
        return this.oneExchangePerUpdate;
    }

    public void setOneExchangePerUpdate(boolean oneExchangePerUpdate) {
        this.oneExchangePerUpdate = oneExchangePerUpdate;
    }

    public boolean isAutoUnsubscribe() {
        return this.autoUnsubscribe;
    }

    public void setAutoUnsubscribe(boolean autoUnsubscribe) {
        this.autoUnsubscribe = autoUnsubscribe;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isFireExistingQueryResults() {
        return this.fireExistingQueryResults;
    }

    public void setFireExistingQueryResults(boolean fireExistingQueryResults) {
        this.fireExistingQueryResults = fireExistingQueryResults;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }
}

