/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.events;

import java.util.Arrays;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.ignite.events.IgniteEventsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.ignite.IgniteEvents;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgnitePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgniteEventsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(IgniteEventsConsumer.class);
    private IgniteEventsEndpoint endpoint;
    private IgniteEvents events;
    private int[] eventTypes = new int[0];
    private IgnitePredicate<Event> predicate = new IgnitePredicate<Event>(){
        private static final long serialVersionUID = 6738594728074592726L;

        public boolean apply(Event event) {
            Exchange exchange = IgniteEventsConsumer.this.endpoint.createExchange(ExchangePattern.InOnly);
            Message in = exchange.getIn();
            in.setBody((Object)event);
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing Ignite Event: {}.", (Object)event);
                }
                IgniteEventsConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                    }
                });
            }
            catch (Exception e) {
                LOG.error(String.format("Exception while processing Ignite Event: %s.", event), (Throwable)e);
            }
            return true;
        }
    };

    public IgniteEventsConsumer(IgniteEventsEndpoint endpoint, Processor processor, IgniteEvents events) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.events = events;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.endpoint.getEvents() != null && this.endpoint.getEvents().size() > 0) {
            this.eventTypes = new int[this.endpoint.getEvents().size()];
            int counter = 0;
            for (Integer i : this.endpoint.getEvents()) {
                this.eventTypes[counter++] = i;
            }
        }
        this.events.localListen(this.predicate, this.eventTypes);
        LOG.info("Started local Ignite Events consumer for events: {}.", Arrays.asList(new int[][]{this.eventTypes}));
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.events.stopLocalListen(this.predicate, this.eventTypes);
        LOG.info("Stopped local Ignite Events consumer for events: {}.", Arrays.asList(new int[][]{this.eventTypes}));
    }
}

