/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.compute;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ignite.AbstractIgniteEndpoint;
import org.apache.camel.component.ignite.ClusterGroupExpression;
import org.apache.camel.component.ignite.IgniteComponent;
import org.apache.camel.component.ignite.compute.IgniteComputeExecutionType;
import org.apache.camel.component.ignite.compute.IgniteComputeProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCompute;

@UriEndpoint(scheme="ignite:compute", title="Ignite Compute", syntax="ignite:compute:[endpointId]", label="nosql,cache,compute", producerOnly=true)
public class IgniteComputeEndpoint
extends AbstractIgniteEndpoint {
    @UriParam
    private ClusterGroupExpression clusterGroupExpression;
    @UriParam
    private IgniteComputeExecutionType executionType;
    @UriParam
    private String taskName;
    @UriParam
    private String computeName;
    @UriParam
    private Long timeoutMillis;

    public IgniteComputeEndpoint(String uri, URI remainingUri, Map<String, Object> parameters, IgniteComponent igniteComponent) throws ClassNotFoundException {
        super(uri, (Component)igniteComponent);
    }

    public Producer createProducer() throws Exception {
        return new IgniteComputeProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The Ignite Compute endpoint does not support consumers.");
    }

    public IgniteCompute createIgniteCompute() {
        IgniteCompute compute;
        Ignite ignite = this.ignite();
        IgniteCompute igniteCompute = compute = this.clusterGroupExpression == null ? ignite.compute() : ignite.compute(this.clusterGroupExpression.getClusterGroup(ignite));
        if (this.computeName != null) {
            compute = compute.withName(this.computeName);
        }
        if (this.timeoutMillis != null) {
            compute = compute.withTimeout(this.timeoutMillis.longValue());
        }
        return compute;
    }

    public IgniteComputeExecutionType getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(IgniteComputeExecutionType executionType) {
        this.executionType = executionType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getComputeName() {
        return this.computeName;
    }

    public void setComputeName(String computeName) {
        this.computeName = computeName;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }
}

