/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientConnection;
import org.apache.camel.component.iec60870.client.ClientEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandScaledValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandShortFloatingPoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SingleCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;

public class ClientProducer
extends DefaultProducer {
    private final ClientConnection connection;
    private final ASDUHeader header;
    private final InformationObjectAddress address;

    public ClientProducer(ClientEndpoint endpoint, ClientConnection connection) {
        super((Endpoint)endpoint);
        this.connection = connection;
        ObjectAddress address = endpoint.getAddress();
        this.header = new ASDUHeader(CauseOfTransmission.ACTIVATED, address.getASDUAddress());
        this.address = address.getInformationObjectAddress();
    }

    public void process(Exchange exchange) throws Exception {
        Object command = this.mapToCommand(exchange);
        if (command != null && !this.connection.executeCommand(command)) {
            throw new IllegalStateException("Failed to send command. Not connected.");
        }
    }

    private Object mapToCommand(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body instanceof Float || body instanceof Double) {
            return this.makeFloatCommand(((Number)body).floatValue());
        }
        if (body instanceof Boolean) {
            return this.makeBooleanCommand((Boolean)body);
        }
        if (body instanceof Integer || body instanceof Short || body instanceof Byte || body instanceof Long) {
            return this.makeIntCommand(((Number)body).longValue());
        }
        throw new IllegalArgumentException("Unable to map value to a command: " + body);
    }

    private Object makeBooleanCommand(Boolean state) {
        return new SingleCommand(this.header, this.address, state.booleanValue());
    }

    private Object makeIntCommand(long value) {
        if (value < -32768L || value > 32767L) {
            throw new IllegalArgumentException(String.format("Integer value is outside of range - min: %s, max: %s", (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
        }
        return new SetPointCommandScaledValue(this.header, this.address, (short)value);
    }

    private Object makeFloatCommand(float value) {
        return new SetPointCommandShortFloatingPoint(this.header, this.address, value);
    }
}

