/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.iec60870.server.ServerEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.eclipse.neoscada.protocol.iec60870.ASDUAddressType;
import org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType;
import org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;

public class ServerEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return ServerEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return ServerEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "filterNonExecute": {
                ((ServerEndpoint)((Object)endpoint)).setFilterNonExecute((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "dataModuleOptions": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setDataModuleOptions((DataModuleOptions)ServerEndpointConfigurer.property((CamelContext)camelContext, DataModuleOptions.class, (Object)value));
                return true;
            }
            case "ignoreBackgroundScan": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setIgnoreBackgroundScan((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "causeSourceAddress": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setCauseSourceAddress((Byte)ServerEndpointConfigurer.property((CamelContext)camelContext, Byte.TYPE, (Object)value));
                return true;
            }
            case "protocolOptions": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setProtocolOptions((ProtocolOptions)ServerEndpointConfigurer.property((CamelContext)camelContext, ProtocolOptions.class, (Object)value));
                return true;
            }
            case "adsuAddressType": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setAdsuAddressType((ASDUAddressType)ServerEndpointConfigurer.property((CamelContext)camelContext, ASDUAddressType.class, (Object)value));
                return true;
            }
            case "informationObjectAddressType": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setInformationObjectAddressType((InformationObjectAddressType)ServerEndpointConfigurer.property((CamelContext)camelContext, InformationObjectAddressType.class, (Object)value));
                return true;
            }
            case "causeOfTransmissionType": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setCauseOfTransmissionType((CauseOfTransmissionType)ServerEndpointConfigurer.property((CamelContext)camelContext, CauseOfTransmissionType.class, (Object)value));
                return true;
            }
            case "timeZone": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeZone((TimeZone)ServerEndpointConfigurer.property((CamelContext)camelContext, TimeZone.class, (Object)value));
                return true;
            }
            case "ignoreDaylightSavingTime": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setIgnoreDaylightSavingTime((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeout1": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout1((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout2": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout2((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout3": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout3((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxUnacknowledged": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setMaxUnacknowledged((Short)ServerEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "acknowledgeWindow": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setAcknowledgeWindow((Short)ServerEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "connectionId": {
                ((ServerEndpoint)((Object)endpoint)).setConnectionId((String)ServerEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((ServerEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((ServerEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((ServerEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ServerEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((ServerEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ServerEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ServerEndpoint)((Object)endpoint)).setSynchronous((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((ServerEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "filternonexecute": {
                ((ServerEndpoint)((Object)endpoint)).setFilterNonExecute((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "datamoduleoptions": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setDataModuleOptions((DataModuleOptions)ServerEndpointConfigurer.property((CamelContext)camelContext, DataModuleOptions.class, (Object)value));
                return true;
            }
            case "ignorebackgroundscan": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setIgnoreBackgroundScan((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "causesourceaddress": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setCauseSourceAddress((Byte)ServerEndpointConfigurer.property((CamelContext)camelContext, Byte.TYPE, (Object)value));
                return true;
            }
            case "protocoloptions": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setProtocolOptions((ProtocolOptions)ServerEndpointConfigurer.property((CamelContext)camelContext, ProtocolOptions.class, (Object)value));
                return true;
            }
            case "adsuaddresstype": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setAdsuAddressType((ASDUAddressType)ServerEndpointConfigurer.property((CamelContext)camelContext, ASDUAddressType.class, (Object)value));
                return true;
            }
            case "informationobjectaddresstype": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setInformationObjectAddressType((InformationObjectAddressType)ServerEndpointConfigurer.property((CamelContext)camelContext, InformationObjectAddressType.class, (Object)value));
                return true;
            }
            case "causeoftransmissiontype": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setCauseOfTransmissionType((CauseOfTransmissionType)ServerEndpointConfigurer.property((CamelContext)camelContext, CauseOfTransmissionType.class, (Object)value));
                return true;
            }
            case "timezone": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeZone((TimeZone)ServerEndpointConfigurer.property((CamelContext)camelContext, TimeZone.class, (Object)value));
                return true;
            }
            case "ignoredaylightsavingtime": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setIgnoreDaylightSavingTime((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeout1": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout1((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout2": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout2((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "timeout3": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setTimeout3((Integer)ServerEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxunacknowledged": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setMaxUnacknowledged((Short)ServerEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "acknowledgewindow": {
                ((ServerEndpoint)((Object)endpoint)).getConnectionOptions().setAcknowledgeWindow((Short)ServerEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "connectionid": {
                ((ServerEndpoint)((Object)endpoint)).setConnectionId((String)ServerEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((ServerEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((ServerEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((ServerEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ServerEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((ServerEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ServerEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ServerEndpoint)((Object)endpoint)).setSynchronous((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((ServerEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ServerEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

