/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.server.ServerEndpoint;
import org.apache.camel.component.iec60870.server.ServerInstance;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.WriteModel;

public class ServerConsumer
extends DefaultConsumer {
    private final ServerInstance server;
    private final ServerEndpoint endpoint;

    public ServerConsumer(ServerEndpoint endpoint, Processor processor, ServerInstance server) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.server = server;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server.setListener(this.endpoint.getAddress(), this::updateValue);
    }

    protected void doStop() throws Exception {
        this.server.setListener(this.endpoint.getAddress(), null);
        super.doStop();
    }

    private CompletionStage<Void> updateValue(WriteModel.Request<?> value) {
        try {
            Exchange exchange = this.getEndpoint().createExchange();
            exchange.setIn(this.mapMessage(value));
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            this.getAsyncProcessor().process(exchange, doneSync -> result.complete(null));
            return result;
        }
        catch (Exception e) {
            this.log.debug("Failed to process message", (Throwable)e);
            CompletableFuture<Void> result = new CompletableFuture<Void>();
            result.completeExceptionally(e);
            return result;
        }
    }

    private Message mapMessage(WriteModel.Request<?> request) {
        DefaultMessage message = new DefaultMessage(this.endpoint.getCamelContext());
        message.setBody(request);
        message.setHeader("address", (Object)ObjectAddress.valueOf(request.getHeader().getAsduAddress(), request.getAddress()));
        message.setHeader("value", request.getValue());
        message.setHeader("informationObjectAddress", (Object)request.getAddress());
        message.setHeader("asduHeader", (Object)request.getHeader());
        message.setHeader("type", (Object)request.getType());
        message.setHeader("execute", (Object)request.isExecute());
        return message;
    }
}

