/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.iec60870.AbstractIecComponent;
import org.apache.camel.component.iec60870.ConnectionId;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientConnection;
import org.apache.camel.component.iec60870.client.ClientConnectionMultiplexor;
import org.apache.camel.component.iec60870.client.ClientEndpoint;
import org.apache.camel.component.iec60870.client.ClientOptions;
import org.apache.camel.impl.DefaultComponent;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientComponent
extends AbstractIecComponent<ClientConnectionMultiplexor, ClientOptions> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientComponent.class);

    public ClientComponent(CamelContext context) {
        super(ClientOptions.class, new ClientOptions(), context, ClientEndpoint.class);
    }

    public ClientComponent() {
        super(ClientOptions.class, new ClientOptions(), ClientEndpoint.class);
    }

    @Override
    protected void applyDataModuleOptions(ClientOptions options, Map<String, Object> parameters) {
        if (parameters.get("dataModuleOptions") instanceof DataModuleOptions) {
            options.setDataModuleOptions((DataModuleOptions)parameters.get("dataModuleOptions"));
        }
    }

    @Override
    protected Endpoint createEndpoint(String uri, ClientConnectionMultiplexor connection, ObjectAddress address) {
        return new ClientEndpoint(uri, (DefaultComponent)this, connection, address);
    }

    @Override
    protected ClientConnectionMultiplexor createConnection(ConnectionId id, ClientOptions options) {
        LOG.debug("Create new connection - id: {}", (Object)id);
        return new ClientConnectionMultiplexor(new ClientConnection(id.getHost(), id.getPort(), options));
    }

    @Override
    public void setDefaultConnectionOptions(ClientOptions defaultConnectionOptions) {
        super.setDefaultConnectionOptions(defaultConnectionOptions);
    }

    @Override
    public ClientOptions getDefaultConnectionOptions() {
        return (ClientOptions)super.getDefaultConnectionOptions();
    }
}

