/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.watson.language;

import com.ibm.watson.natural_language_understanding.v1.NaturalLanguageUnderstanding;
import com.ibm.watson.natural_language_understanding.v1.model.AnalysisResults;
import com.ibm.watson.natural_language_understanding.v1.model.AnalyzeOptions;
import com.ibm.watson.natural_language_understanding.v1.model.CategoriesOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ConceptsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.EmotionOptions;
import com.ibm.watson.natural_language_understanding.v1.model.EntitiesOptions;
import com.ibm.watson.natural_language_understanding.v1.model.Features;
import com.ibm.watson.natural_language_understanding.v1.model.KeywordsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.SentimentOptions;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageEndpoint;
import org.apache.camel.component.ibm.watson.language.WatsonLanguageOperations;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatsonLanguageProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(WatsonLanguageProducer.class);

    public WatsonLanguageProducer(WatsonLanguageEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        WatsonLanguageOperations operation = this.determineOperation(exchange);
        switch (operation) {
            case analyzeText: {
                this.analyzeText(exchange);
                break;
            }
            case analyzeUrl: {
                this.analyzeUrl(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + String.valueOf((Object)operation));
            }
        }
    }

    public WatsonLanguageEndpoint getEndpoint() {
        return (WatsonLanguageEndpoint)super.getEndpoint();
    }

    private WatsonLanguageOperations determineOperation(Exchange exchange) {
        WatsonLanguageOperations operation = (WatsonLanguageOperations)((Object)exchange.getIn().getHeader("CamelIBMWatsonLanguageOperation", WatsonLanguageOperations.class));
        if (operation == null) {
            operation = this.getEndpoint().getConfiguration().getOperation();
        }
        if (operation == null) {
            throw new IllegalArgumentException("Operation must be specified");
        }
        return operation;
    }

    private void analyzeText(Exchange exchange) {
        NaturalLanguageUnderstanding nlu = this.getEndpoint().getNluClient();
        if (nlu == null) {
            throw new IllegalStateException("NLU client not initialized. Use service=nlu");
        }
        String text = (String)exchange.getIn().getHeader("CamelIBMWatsonLanguageText", String.class);
        if (text == null) {
            text = (String)exchange.getIn().getBody(String.class);
        }
        if (text == null || text.isBlank()) {
            throw new IllegalArgumentException("Text to analyze must be specified");
        }
        LOG.trace("Analyzing text with NLU");
        Features features = this.buildFeatures(exchange);
        AnalyzeOptions options = new AnalyzeOptions.Builder().text(text).features(features).build();
        AnalysisResults result = (AnalysisResults)nlu.analyze(options).execute().getResult();
        Message message = this.getMessageForResponse(exchange);
        message.setBody((Object)result);
        if (result.getSentiment() != null && result.getSentiment().getDocument() != null) {
            message.setHeader("CamelIBMWatsonLanguageSentimentScore", (Object)result.getSentiment().getDocument().getScore());
            message.setHeader("CamelIBMWatsonLanguageSentimentLabel", (Object)result.getSentiment().getDocument().getLabel());
        }
        if (result.getLanguage() != null) {
            message.setHeader("CamelIBMWatsonLanguageLanguage", (Object)result.getLanguage());
        }
    }

    private void analyzeUrl(Exchange exchange) {
        NaturalLanguageUnderstanding nlu = this.getEndpoint().getNluClient();
        if (nlu == null) {
            throw new IllegalStateException("NLU client not initialized. Use service=nlu");
        }
        String url = (String)exchange.getIn().getHeader("CamelIBMWatsonLanguageUrl", String.class);
        if (url == null) {
            url = (String)exchange.getIn().getBody(String.class);
        }
        if (url == null || url.isBlank()) {
            throw new IllegalArgumentException("URL to analyze must be specified");
        }
        LOG.trace("Analyzing URL with NLU: {}", (Object)url);
        Features features = this.buildFeatures(exchange);
        AnalyzeOptions options = new AnalyzeOptions.Builder().url(url).features(features).build();
        AnalysisResults result = (AnalysisResults)nlu.analyze(options).execute().getResult();
        Message message = this.getMessageForResponse(exchange);
        message.setBody((Object)result);
        if (result.getSentiment() != null && result.getSentiment().getDocument() != null) {
            message.setHeader("CamelIBMWatsonLanguageSentimentScore", (Object)result.getSentiment().getDocument().getScore());
            message.setHeader("CamelIBMWatsonLanguageSentimentLabel", (Object)result.getSentiment().getDocument().getLabel());
        }
        if (result.getLanguage() != null) {
            message.setHeader("CamelIBMWatsonLanguageLanguage", (Object)result.getLanguage());
        }
    }

    private Features buildFeatures(Exchange exchange) {
        Features.Builder builder = new Features.Builder();
        boolean analyzeSentiment = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeSentiment", (Object)this.getEndpoint().getConfiguration().isAnalyzeSentiment(), Boolean.class);
        boolean analyzeEmotion = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeEmotion", (Object)this.getEndpoint().getConfiguration().isAnalyzeEmotion(), Boolean.class);
        boolean analyzeEntities = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeEntities", (Object)this.getEndpoint().getConfiguration().isAnalyzeEntities(), Boolean.class);
        boolean analyzeKeywords = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeKeywords", (Object)this.getEndpoint().getConfiguration().isAnalyzeKeywords(), Boolean.class);
        boolean analyzeConcepts = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeConcepts", (Object)this.getEndpoint().getConfiguration().isAnalyzeConcepts(), Boolean.class);
        boolean analyzeCategories = (Boolean)exchange.getIn().getHeader("CamelIBMWatsonLanguageAnalyzeCategories", (Object)this.getEndpoint().getConfiguration().isAnalyzeCategories(), Boolean.class);
        if (analyzeSentiment) {
            builder.sentiment(new SentimentOptions.Builder().build());
        }
        if (analyzeEmotion) {
            builder.emotion(new EmotionOptions.Builder().build());
        }
        if (analyzeEntities) {
            builder.entities(new EntitiesOptions.Builder().build());
        }
        if (analyzeKeywords) {
            builder.keywords(new KeywordsOptions.Builder().build());
        }
        if (analyzeConcepts) {
            builder.concepts(new ConceptsOptions.Builder().build());
        }
        if (analyzeCategories) {
            builder.categories(new CategoriesOptions.Builder().build());
        }
        return builder.build();
    }

    private Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

