/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.models;

import org.apache.camel.FunctionGraphEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigurations {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClientConfigurations.class.getName());
    private String operation;
    private String region;
    private String projectId;
    private String functionPackage;
    private String functionName;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private boolean ignoreSslVerification;
    private String endpoint;
    private String accessKey;
    private String secretKey;
    private String xcffLogType;

    public ClientConfigurations(FunctionGraphEndpoint endpoint) {
        if (ObjectHelper.isNotEmpty((Object)endpoint.getEndpoint())) {
            this.setEndpoint(endpoint.getEndpoint());
        } else if (ObjectHelper.isNotEmpty((Object)endpoint.getRegion())) {
            this.setRegion(endpoint.getRegion());
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error("No region/endpoint given. Cannot proceed with FunctionGraph operations.");
            }
            throw new IllegalArgumentException("Region/endpoint not found");
        }
        if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyHost()) && ObjectHelper.isNotEmpty((Object)endpoint.getProxyPort())) {
            this.setProxyHost(endpoint.getProxyHost());
            this.setProxyPort(endpoint.getProxyPort());
        }
        if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyUser())) {
            this.setProxyUser(endpoint.getProxyUser());
            if (ObjectHelper.isNotEmpty((Object)endpoint.getProxyPassword())) {
                this.setProxyPassword(endpoint.getProxyPassword());
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Proxy password not provided. Continuing without it.");
            }
        }
        if (ObjectHelper.isEmpty((Object)endpoint.getProjectId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No project ID given. Cannot proceed with FunctionGraph operations.");
            }
            throw new IllegalArgumentException("Project ID not found");
        }
        this.setProjectId(endpoint.getProjectId());
        if (endpoint.isIgnoreSslVerification() && LOG.isWarnEnabled()) {
            LOG.warn("SSL verification is ignored. This is unsafe in production environment");
        }
        this.setIgnoreSslVerification(endpoint.isIgnoreSslVerification());
        if (ObjectHelper.isEmpty((Object)endpoint.getAccessKey()) && ObjectHelper.isEmpty((Object)endpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No access key (AK) given. Cannot proceed with FunctionGraph operations");
            }
            throw new IllegalArgumentException("Authentication parameter 'access key (AK)' not found");
        }
        this.setAccessKey(ObjectHelper.isNotEmpty((Object)endpoint.getServiceKeys()) ? endpoint.getServiceKeys().getAccessKey() : endpoint.getAccessKey());
        if (ObjectHelper.isEmpty((Object)endpoint.getSecretKey()) && ObjectHelper.isEmpty((Object)endpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No secret key (SK) given. Cannot proceed with FunctionGraph operations");
            }
            throw new IllegalArgumentException("Authentication parameter 'secret key (SK)' not found");
        }
        this.setSecretKey(ObjectHelper.isNotEmpty((Object)endpoint.getServiceKeys()) ? endpoint.getServiceKeys().getSecretKey() : endpoint.getSecretKey());
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getFunctionPackage() {
        return this.functionPackage;
    }

    public void setFunctionPackage(String functionPackage) {
        this.functionPackage = functionPackage;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isIgnoreSslVerification() {
        return this.ignoreSslVerification;
    }

    public void setIgnoreSslVerification(boolean ignoreSslVerification) {
        this.ignoreSslVerification = ignoreSslVerification;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getXCffLogType() {
        return this.xcffLogType;
    }

    public void setXCffLogType(String xcffLogType) {
        this.xcffLogType = xcffLogType;
    }
}

