/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.functiongraph.v2.FunctionGraphClient;
import com.huaweicloud.sdk.functiongraph.v2.region.FunctionGraphRegion;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.FunctionGraphComponent;
import org.apache.camel.FunctionGraphProducer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.huaweicloud.common.models.ServiceKeys;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.11.0", scheme="hwcloud-functiongraph", title="Huawei FunctionGraph", syntax="hwcloud-functiongraph:operation", category={Category.CLOUD, Category.SERVERLESS}, producerOnly=true)
public class FunctionGraphEndpoint
extends DefaultEndpoint {
    @UriPath(description="Operation to be performed", displayName="Operation", label="producer", secret=false)
    @Metadata(required=true)
    private String operation;
    @UriParam(description="FunctionGraph service region. This is lower precedence than endpoint based configuration", displayName="Service region", secret=false)
    @Metadata(required=true)
    private String region;
    @UriParam(description="Cloud project ID", displayName="Project ID", secret=false)
    @Metadata(required=true)
    private String projectId;
    @UriParam(description="Functions that can be logically grouped together", displayName="Function package", secret=false, defaultValue="default")
    @Metadata(required=false)
    private String functionPackage;
    @UriParam(description="Name of the function to invoke", displayName="Function name", secret=false)
    @Metadata(required=false)
    private String functionName;
    @UriParam(description="Proxy server ip/hostname", displayName="Proxy server host", secret=false, label="proxy")
    @Metadata(required=false)
    private String proxyHost;
    @UriParam(description="Proxy server port", displayName="Proxy server port", secret=false, label="proxy")
    @Metadata(required=false)
    private int proxyPort;
    @UriParam(description="Proxy authentication user", displayName="Proxy user", secret=true, label="proxy")
    @Metadata(required=false)
    private String proxyUser;
    @UriParam(description="Proxy authentication password", displayName="Proxy password", secret=true, label="proxy")
    @Metadata(required=false)
    private String proxyPassword;
    @UriParam(description="Ignore SSL verification", displayName="SSL Verification Ignored", secret=false, defaultValue="false", label="security")
    @Metadata(required=false)
    private boolean ignoreSslVerification;
    @UriParam(description="FunctionGraph url. Carries higher precedence than region parameter based client initialization", displayName="Service endpoint", secret=false)
    @Metadata(required=false)
    private String endpoint;
    @UriParam(description="Configuration object for cloud service authentication", displayName="Service Configuration", secret=true)
    @Metadata(required=false)
    private ServiceKeys serviceKeys;
    @UriParam(description="Access key for the cloud user", displayName="API access key (AK)", secret=true, label="security")
    @Metadata(required=true)
    private String accessKey;
    @UriParam(description="Secret key for the cloud user", displayName="API secret key (SK)", secret=true, label="security")
    @Metadata(required=true)
    private String secretKey;
    private FunctionGraphClient functionGraphClient;

    public FunctionGraphEndpoint() {
    }

    public FunctionGraphEndpoint(String uri, String operation, FunctionGraphComponent component) {
        super(uri, (Component)component);
        this.operation = operation;
    }

    public Producer createProducer() throws Exception {
        return new FunctionGraphProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getFunctionPackage() {
        return this.functionPackage;
    }

    public void setFunctionPackage(String functionPackage) {
        this.functionPackage = functionPackage;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isIgnoreSslVerification() {
        return this.ignoreSslVerification;
    }

    public void setIgnoreSslVerification(boolean ignoreSslVerification) {
        this.ignoreSslVerification = ignoreSslVerification;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public ServiceKeys getServiceKeys() {
        return this.serviceKeys;
    }

    public void setServiceKeys(ServiceKeys serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public FunctionGraphClient getFunctionGraphClient() {
        return this.functionGraphClient;
    }

    public void setFunctionGraphClient(FunctionGraphClient functionGraphClient) {
        this.functionGraphClient = functionGraphClient;
    }

    public FunctionGraphClient initClient() {
        if (this.functionGraphClient != null) {
            return this.functionGraphClient;
        }
        BasicCredentials auth = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(this.getServiceKeys() != null ? this.getServiceKeys().getAccessKey() : this.getAccessKey())).withSk(this.getServiceKeys() != null ? this.getServiceKeys().getSecretKey() : this.getSecretKey())).withProjectId(this.getProjectId());
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig();
        httpConfig.withIgnoreSSLVerification(this.isIgnoreSslVerification());
        if (ObjectHelper.isNotEmpty((Object)this.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.getProxyPort())) {
            httpConfig.withProxyHost(this.getProxyHost()).withProxyPort(this.getProxyPort());
            if (ObjectHelper.isNotEmpty((Object)this.getProxyUser())) {
                httpConfig.withProxyUsername(this.getProxyUser());
                if (ObjectHelper.isNotEmpty((Object)this.getProxyPassword())) {
                    httpConfig.withProxyPassword(this.getProxyPassword());
                }
            }
        }
        if (ObjectHelper.isNotEmpty((Object)this.getEndpoint())) {
            return (FunctionGraphClient)FunctionGraphClient.newBuilder().withCredential((ICredential)auth).withHttpConfig(httpConfig).withEndpoint(this.getEndpoint()).build();
        }
        return (FunctionGraphClient)FunctionGraphClient.newBuilder().withCredential((ICredential)auth).withHttpConfig(httpConfig).withRegion(FunctionGraphRegion.valueOf((String)this.getRegion())).build();
    }
}

