/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.hl7.Hl7TerserLanguage;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;

public class Hl7TerserAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String hl7 = this.getExpressionFromAnnotation(annotation);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        String source = this.getSource(annotation);
        Expression input = ExpressionBuilder.singleInputExpression((String)source);
        Expression exp = Hl7TerserLanguage.terser(input, hl7);
        return ExpressionBuilder.convertToExpression((Expression)exp, resultType);
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }

    protected String getSource(Annotation annotation) {
        String answer = null;
        try {
            answer = (String)this.getAnnotationObjectValue(annotation, "source");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer != null && answer.isBlank()) {
            return null;
        }
        return answer;
    }
}

