/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hashicorp.vault;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.HashicorpVaultConfiguration;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultResponse;

@PropertiesFunction(value="hashicorp")
public class HashicorpVaultPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_HASHICORP_VAULT_TOKEN_ENV = "CAMEL_HASHICORP_VAULT_TOKEN";
    private static final String CAMEL_HASHICORP_VAULT_ENGINE_ENV = "CAMEL_HASHICORP_VAULT_ENGINE";
    private static final String CAMEL_HASHICORP_VAULT_HOST_ENV = "CAMEL_HASHICORP_VAULT_HOST";
    private static final String CAMEL_HASHICORP_VAULT_PORT_ENV = "CAMEL_HASHICORP_VAULT_PORT";
    private static final String CAMEL_HASHICORP_VAULT_SCHEME_ENV = "CAMEL_HASHICORP_VAULT_SCHEME";
    private CamelContext camelContext;
    private VaultTemplate client;
    private String engine;

    protected void doStart() throws Exception {
        HashicorpVaultConfiguration hashicorpVaultConfiguration;
        super.doStart();
        String token = System.getenv(CAMEL_HASHICORP_VAULT_TOKEN_ENV);
        this.engine = System.getenv(CAMEL_HASHICORP_VAULT_ENGINE_ENV);
        String host = System.getenv(CAMEL_HASHICORP_VAULT_HOST_ENV);
        String port = System.getenv(CAMEL_HASHICORP_VAULT_PORT_ENV);
        String scheme = System.getenv(CAMEL_HASHICORP_VAULT_SCHEME_ENV);
        if (ObjectHelper.isEmpty((String)token) && ObjectHelper.isEmpty((String)this.engine) && ObjectHelper.isEmpty((String)host) && ObjectHelper.isEmpty((String)port) && ObjectHelper.isEmpty((String)scheme) && ObjectHelper.isNotEmpty((Object)(hashicorpVaultConfiguration = this.getCamelContext().getVaultConfiguration().hashicorp()))) {
            token = hashicorpVaultConfiguration.getToken();
            this.engine = hashicorpVaultConfiguration.getEngine();
            host = hashicorpVaultConfiguration.getHost();
            port = hashicorpVaultConfiguration.getPort();
            scheme = hashicorpVaultConfiguration.getScheme();
        }
        if (!(ObjectHelper.isNotEmpty((String)token) && ObjectHelper.isNotEmpty((String)this.engine) && ObjectHelper.isNotEmpty((String)host) && ObjectHelper.isNotEmpty((String)port) && ObjectHelper.isNotEmpty((String)scheme))) {
            throw new RuntimeCamelException("Using the Hashicorp Properties Function requires setting Engine, Token, Host, port and scheme properties");
        }
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(host);
        vaultEndpoint.setPort(Integer.parseInt(port));
        vaultEndpoint.setScheme(scheme);
        this.client = new VaultTemplate(vaultEndpoint, (ClientAuthentication)new TokenAuthentication(token));
    }

    public String getName() {
        return "hashicorp";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        String version = null;
        if (remainder.contains("/")) {
            key = StringHelper.before((String)remainder, (String)"/");
            subkey = StringHelper.after((String)remainder, (String)"/");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                version = StringHelper.after((String)defaultValue, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
            if (subkey.contains("@")) {
                version = StringHelper.after((String)subkey, (String)"@");
                subkey = StringHelper.before((String)subkey, (String)"@");
            }
        } else if (remainder.contains(":")) {
            key = StringHelper.before((String)remainder, (String)":");
            defaultValue = StringHelper.after((String)remainder, (String)":");
            if (remainder.contains("@")) {
                version = StringHelper.after((String)remainder, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
        } else if (remainder.contains("@")) {
            key = StringHelper.before((String)remainder, (String)"@");
            version = StringHelper.after((String)remainder, (String)"@");
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue, version);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue, String version) {
        String returnValue = null;
        try {
            VaultResponse rawSecret;
            String completePath = this.engine + "/data/" + key;
            if (ObjectHelper.isNotEmpty((String)version)) {
                completePath = completePath + "?version=" + version;
            }
            if (ObjectHelper.isNotEmpty((Object)(rawSecret = this.client.read(completePath)))) {
                returnValue = ((Map)rawSecret.getData()).get("data").toString();
            }
            if (ObjectHelper.isNotEmpty((String)subkey)) {
                Object field = ((Map)((Map)rawSecret.getData()).get("data")).get(subkey);
                returnValue = ObjectHelper.isNotEmpty(field) ? field.toString() : null;
            }
            if (ObjectHelper.isEmpty((String)returnValue)) {
                returnValue = defaultValue;
            }
        }
        catch (Exception ex) {
            if (ObjectHelper.isNotEmpty((String)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

