/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hashicorp.vault;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultConfiguration;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultConstants;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;

@UriEndpoint(firstVersion="3.18.0", scheme="hashicorp-vault", title="Hashicorp Vault", syntax="hashicorp-vault:secretsEngine", category={Category.CLOUD, Category.CLOUD}, producerOnly=true, headersClass=HashicorpVaultConstants.class)
@Metadata(annotations={"vault=hashicorp-vault"})
public class HashicorpVaultEndpoint
extends DefaultEndpoint {
    private VaultTemplate vaultTemplate;
    @UriParam
    private HashicorpVaultConfiguration configuration;

    public HashicorpVaultEndpoint(String uri, Component component, HashicorpVaultConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doInit() throws Exception {
        super.doInit();
        this.vaultTemplate = this.configuration.getVaultTemplate() != null ? this.configuration.getVaultTemplate() : this.createVaultTemplate();
    }

    private VaultTemplate createVaultTemplate() {
        VaultEndpoint vaultEndpoint = new VaultEndpoint();
        vaultEndpoint.setHost(this.configuration.getHost());
        vaultEndpoint.setPort(Integer.parseInt(this.configuration.getPort()));
        vaultEndpoint.setScheme(this.configuration.getScheme());
        VaultTemplate vaultTemplate = new VaultTemplate(vaultEndpoint, (ClientAuthentication)new TokenAuthentication(this.configuration.getToken()));
        return vaultTemplate;
    }

    public Producer createProducer() throws Exception {
        return new HashicorpVaultProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public HashicorpVaultConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HashicorpVaultConfiguration configuration) {
        this.configuration = configuration;
    }

    public VaultTemplate getVaultTemplate() {
        return this.vaultTemplate;
    }

    public void setVaultTemplate(VaultTemplate vaultTemplate) {
        this.vaultTemplate = vaultTemplate;
    }
}

