/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hashicorp.vault;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultConfiguration;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="hashicorp-vault")
public class HashicorpVaultComponent
extends DefaultComponent {
    @Metadata
    private HashicorpVaultConfiguration configuration = new HashicorpVaultConfiguration();

    public HashicorpVaultComponent() {
    }

    public HashicorpVaultComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("A vault name must be specified.");
        }
        HashicorpVaultConfiguration epConfiguration = this.configuration != null ? this.configuration.copy() : new HashicorpVaultConfiguration();
        epConfiguration.setSecretsEngine(remaining);
        HashicorpVaultEndpoint endpoint = new HashicorpVaultEndpoint(uri, (Component)this, epConfiguration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (epConfiguration.getVaultTemplate() == null && epConfiguration.getToken() == null) {
            throw new IllegalArgumentException("Vault Template or token must be specified");
        }
        return endpoint;
    }
}

