/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hashicorp.vault;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultConfiguration;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultEndpoint;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.support.VaultResponse;

public class HashicorpVaultProducer
extends DefaultProducer {
    public HashicorpVaultProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        HashicorpVaultOperation operation = this.determineOperation(exchange);
        switch (operation) {
            case createSecret: {
                this.createSecret(exchange);
                break;
            }
            case getSecret: {
                this.getSecret(exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret();
                break;
            }
            case listSecrets: {
                this.listSecrets(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createSecret(Exchange exchange) {
        VaultKeyValueOperations keyValue = this.getEndpoint().getVaultTemplate().opsForKeyValue(this.getEndpoint().getConfiguration().getSecretsEngine(), VaultKeyValueOperationsSupport.KeyValueBackend.versioned());
        keyValue.put(this.getEndpoint().getConfiguration().getSecretPath(), exchange.getMessage().getBody());
    }

    private void getSecret(Exchange exchange) {
        String secretVersion = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelHashicorpVaultSecretPath"))) {
            throw new IllegalArgumentException("Secret Path must be specified");
        }
        String secretPath = (String)exchange.getMessage().getHeader("CamelHashicorpVaultSecretPath", String.class);
        if (ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelHashicorpVaultSecretVersion"))) {
            secretVersion = (String)exchange.getMessage().getHeader("CamelHashicorpVaultSecretVersion", String.class);
        }
        String completePath = this.getEndpoint().getConfiguration().getSecretsEngine() + "/data/" + secretPath;
        if (ObjectHelper.isNotEmpty((String)secretVersion)) {
            completePath = completePath + "?version=" + secretVersion;
        }
        VaultResponse rawSecret = this.getEndpoint().getVaultTemplate().read(completePath);
        exchange.getMessage().setBody(rawSecret.getData());
    }

    private void deleteSecret() {
        VaultKeyValueOperations keyValue = this.getEndpoint().getVaultTemplate().opsForKeyValue(this.getEndpoint().getConfiguration().getSecretsEngine(), VaultKeyValueOperationsSupport.KeyValueBackend.versioned());
        keyValue.delete(this.getEndpoint().getConfiguration().getSecretPath());
    }

    private void listSecrets(Exchange exchange) {
        List secretsList = this.getEndpoint().getVaultTemplate().list(this.getEndpoint().getConfiguration().getSecretsEngine() + "/metadata/");
        exchange.getMessage().setBody((Object)secretsList);
    }

    public HashicorpVaultEndpoint getEndpoint() {
        return (HashicorpVaultEndpoint)super.getEndpoint();
    }

    public HashicorpVaultConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private HashicorpVaultOperation determineOperation(Exchange exchange) {
        HashicorpVaultOperation operation = (HashicorpVaultOperation)((Object)exchange.getIn().getHeader("CamelHashicorpVaultProducerOperation", HashicorpVaultOperation.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

