/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hashicorp.vault;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultConfiguration;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultEndpoint;
import org.apache.camel.component.hashicorp.vault.HashicorpVaultOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.support.VaultResponse;

public class HashicorpVaultProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HashicorpVaultProducer.class);

    public HashicorpVaultProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doInit() throws Exception {
        super.doInit();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public void process(Exchange exchange) throws Exception {
        HashicorpVaultOperation operation = this.determineOperation(exchange);
        switch (operation) {
            case createSecret: {
                this.createSecret(exchange);
                break;
            }
            case getSecret: {
                this.getSecret(exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createSecret(Exchange exchange) {
        VaultKeyValueOperations keyValue = this.getEndpoint().getVaultTemplate().opsForKeyValue(this.getEndpoint().getConfiguration().getSecretsEngine(), VaultKeyValueOperationsSupport.KeyValueBackend.versioned());
        keyValue.put(this.getEndpoint().getConfiguration().getSecretPath(), exchange.getMessage().getBody());
    }

    private void getSecret(Exchange exchange) {
        if (!ObjectHelper.isNotEmpty((Object)exchange.getMessage().getHeader("CamelHashicorpVaultSecretPath"))) {
            throw new IllegalArgumentException("Secret Path must be specified");
        }
        String secretPath = (String)exchange.getMessage().getHeader("CamelHashicorpVaultSecretPath", String.class);
        String completePath = this.getEndpoint().getConfiguration().getSecretsEngine() + "/data/" + secretPath;
        VaultResponse rawSecret = this.getEndpoint().getVaultTemplate().read(completePath);
        exchange.getMessage().setBody(rawSecret.getData());
    }

    private void deleteSecret() {
        VaultKeyValueOperations keyValue = this.getEndpoint().getVaultTemplate().opsForKeyValue(this.getEndpoint().getConfiguration().getSecretsEngine(), VaultKeyValueOperationsSupport.KeyValueBackend.versioned());
        keyValue.delete(this.getEndpoint().getConfiguration().getSecretPath());
    }

    public HashicorpVaultEndpoint getEndpoint() {
        return (HashicorpVaultEndpoint)super.getEndpoint();
    }

    public HashicorpVaultConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private HashicorpVaultOperation determineOperation(Exchange exchange) {
        HashicorpVaultOperation operation = (HashicorpVaultOperation)((Object)exchange.getIn().getHeader("CamelHashicorpVaultProducerOperation", HashicorpVaultOperation.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

