/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.auth.jwt;

import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.Executor;
import org.apache.camel.component.grpc.GrpcConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtCallCredentials
implements CallCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(JwtCallCredentials.class);
    private final String jwtToken;

    public JwtCallCredentials(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public void applyRequestMetadata(MethodDescriptor<?, ?> method, Attributes attrs, Executor executor, final CallCredentials.MetadataApplier applier) {
        String authority = (String)attrs.get(ATTR_AUTHORITY);
        LOG.debug("Using authority {} for credentials", (Object)authority);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Start to apply for the JWT token header");
                    Metadata headers = new Metadata();
                    Metadata.Key<String> jwtKey = GrpcConstants.GRPC_JWT_METADATA_KEY;
                    headers.put(jwtKey, (Object)JwtCallCredentials.this.jwtToken);
                    applier.apply(headers);
                }
                catch (Throwable e) {
                    LOG.debug("Unable to set metadata credentials header", e);
                    applier.fail(Status.UNAUTHENTICATED.withCause(e));
                }
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

