/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;

public final class GrpcUtils {
    private GrpcUtils() {
    }

    public static Object constructGrpcAsyncStub(String packageName, String serviceName, Channel channel, CamelContext context) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newStub", channel, context);
    }

    public static Object constructGrpcBlockingStub(String packageName, String serviceName, Channel channel, CamelContext context) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newBlockingStub", channel, context);
    }

    private static Object constructGrpcStubClass(String packageName, String serviceName, String stubMethod, Channel channel, CamelContext context) {
        Class[] paramChannel = new Class[]{Channel.class};
        Object grpcBlockingStub = null;
        String serviceClassName = packageName + "." + serviceName + "Grpc";
        try {
            Class grpcServiceClass = context.getClassResolver().resolveMandatoryClass(serviceClassName);
            Method grpcBlockingMethod = ReflectionHelper.findMethod((Class)grpcServiceClass, (String)stubMethod, (Class[])paramChannel);
            if (grpcBlockingMethod == null) {
                throw new IllegalArgumentException("gRPC service method not found: " + serviceClassName + "." + "newBlockingStub");
            }
            grpcBlockingStub = ObjectHelper.invokeMethod((Method)grpcBlockingMethod, (Object)grpcServiceClass, (Object[])new Object[]{channel});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("gRPC service class not found: " + serviceClassName);
        }
        return grpcBlockingStub;
    }

    public static void invokeAsyncMethod(Object asyncStubClass, String invokeMethod, Object request, StreamObserver responseObserver) {
        Class[] paramMethod = null;
        Method method = ReflectionHelper.findMethod(asyncStubClass.getClass(), (String)invokeMethod, paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + asyncStubClass.getClass().getName() + "." + invokeMethod);
        }
        if (method.getReturnType().equals(StreamObserver.class)) {
            StreamObserver requestObserver = (StreamObserver)ObjectHelper.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{responseObserver});
            if (request instanceof List) {
                List requestList = (List)request;
                requestList.forEach(requestItem -> requestObserver.onNext(requestItem));
            } else {
                requestObserver.onNext(request);
            }
            requestObserver.onCompleted();
        } else {
            ObjectHelper.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{request, responseObserver});
        }
    }

    public static Object invokeSyncMethod(Object blockingStubClass, String invokeMethod, Object request) {
        Class[] paramMethod = null;
        Method method = ReflectionHelper.findMethod(blockingStubClass.getClass(), (String)invokeMethod, paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + blockingStubClass.getClass().getName() + "." + invokeMethod);
        }
        if (method.getReturnType().equals(Iterator.class)) {
            Iterator responseObjects = (Iterator)ObjectHelper.invokeMethod((Method)method, (Object)blockingStubClass, (Object[])new Object[]{request});
            ArrayList objectList = new ArrayList();
            while (responseObjects.hasNext()) {
                objectList.add(responseObjects.next());
            }
            return objectList;
        }
        return ObjectHelper.invokeMethod((Method)method, (Object)blockingStubClass, (Object[])new Object[]{request});
    }

    public static String convertMethod2CamelCase(String method) {
        StringBuilder sb = new StringBuilder(method.length());
        sb.append(method.substring(0, 1).toLowerCase());
        Boolean afterUnderscore = false;
        for (int i = 1; i < method.length(); ++i) {
            if (method.charAt(i) == '_') {
                afterUnderscore = true;
                continue;
            }
            sb.append(afterUnderscore != false ? Character.toUpperCase(method.charAt(i)) : method.charAt(i));
            afterUnderscore = false;
        }
        return sb.toString();
    }
}

