/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;

public final class GrpcUtils {
    private GrpcUtils() {
    }

    public static Object constructGrpcAsyncStub(String packageName, String serviceName, Channel channel) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newStub", channel);
    }

    public static Object constructGrpcBlockingStub(String packageName, String serviceName, Channel channel) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newBlockingStub", channel);
    }

    private static Object constructGrpcStubClass(String packageName, String serviceName, String stubMethod, Channel channel) {
        Class[] paramChannel = new Class[]{Channel.class};
        Object grpcBlockingStub = null;
        String serviceClassName = packageName + "." + serviceName + "Grpc";
        try {
            Class<?> grpcServiceClass = Class.forName(serviceClassName);
            Method grpcBlockingMethod = ReflectionUtils.findMethod(grpcServiceClass, (String)stubMethod, (Class[])paramChannel);
            if (grpcBlockingMethod == null) {
                throw new IllegalArgumentException("gRPC service method not found: " + serviceClassName + "." + "newBlockingStub");
            }
            grpcBlockingStub = ReflectionUtils.invokeMethod((Method)grpcBlockingMethod, grpcServiceClass, (Object[])new Object[]{channel});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("gRPC service class not found: " + serviceClassName);
        }
        return grpcBlockingStub;
    }

    public static void invokeAsyncMethod(Object asyncStubClass, String invokeMethod, Object request, StreamObserver asyncHandler) {
        Class[] paramMethod = new Class[]{request.getClass(), StreamObserver.class};
        Method method = ReflectionUtils.findMethod(asyncStubClass.getClass(), (String)invokeMethod, (Class[])paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + invokeMethod + " with parameter: " + request.getClass().getName());
        }
        ReflectionUtils.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{request, asyncHandler});
    }

    public static Object invokeSyncMethod(Object blockingStubClass, String invokeMethod, Object request) {
        Class[] paramMethod = new Class[]{request.getClass()};
        Object responseObject = null;
        Method method = ReflectionUtils.findMethod(blockingStubClass.getClass(), (String)invokeMethod, (Class[])paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + invokeMethod + " with parameter: " + request.getClass().getName());
        }
        responseObject = ReflectionUtils.invokeMethod((Method)method, (Object)blockingStubClass, (Object[])new Object[]{request});
        return responseObject;
    }

    public static String convertMethod2CamelCase(String method) {
        StringBuilder sb = new StringBuilder(method.length());
        sb.append(method.substring(0, 1).toLowerCase());
        Boolean afterUnderscore = false;
        for (int i = 1; i < method.length(); ++i) {
            if (method.charAt(i) == '_') {
                afterUnderscore = true;
                continue;
            }
            sb.append(afterUnderscore != false ? Character.toUpperCase(method.charAt(i)) : method.charAt(i));
            afterUnderscore = false;
        }
        return sb.toString();
    }
}

