/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcProducer.class);
    protected final GrpcConfiguration configuration;
    protected final GrpcEndpoint endpoint;
    private ManagedChannel channel;
    private Object grpcStub;

    public GrpcProducer(GrpcEndpoint endpoint, GrpcConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Message message = exchange.getIn();
        StreamObserver<Object> asyncHandler = new StreamObserver<Object>(){

            public void onNext(Object response) {
                Object currentBody = exchange.getOut().getBody();
                List<Object> returnBody = new ArrayList<Object>();
                if (currentBody instanceof List) {
                    returnBody = (List)currentBody;
                }
                returnBody.add(response);
                exchange.getOut().setBody(returnBody);
            }

            public void onError(Throwable t) {
                exchange.setException(t);
                callback.done(false);
            }

            public void onCompleted() {
                exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                callback.done(false);
            }
        };
        try {
            GrpcUtils.invokeAsyncMethod(this.grpcStub, this.configuration.getMethod(), message.getBody(), (StreamObserver)asyncHandler);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        Object outBody = GrpcUtils.invokeSyncMethod(this.grpcStub, this.configuration.getMethod(), message.getBody());
        exchange.getOut().setBody(outBody);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.channel == null) {
            this.initializeChannel();
            if (this.endpoint.isSynchronous()) {
                LOG.info("Getting synchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcBlockingStub(this.configuration.getServicePackage(), this.configuration.getServiceName(), (Channel)this.channel);
            } else {
                LOG.info("Getting asynchronous method stub from channel");
                this.grpcStub = GrpcUtils.constructGrpcAsyncStub(this.configuration.getServicePackage(), this.configuration.getServiceName(), (Channel)this.channel);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.channel != null) {
            LOG.trace("Terminating channel to the remote gRPC server");
            this.channel.shutdown().shutdownNow();
            this.channel = null;
            this.grpcStub = null;
        }
        super.doStop();
    }

    protected void initializeChannel() {
        if (!ObjectHelper.isEmpty((Object)this.configuration.getHost()) && !ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            LOG.info("Creating channel to the remote gRPC server " + this.configuration.getHost() + ":" + this.configuration.getPort());
            this.channel = ManagedChannelBuilder.forAddress((String)this.configuration.getHost(), (int)this.configuration.getPort()).usePlaintext(this.configuration.getUsePlainText().booleanValue()).build();
        } else if (!ObjectHelper.isEmpty((Object)this.configuration.getTarget())) {
            LOG.info("Creating channel to the remote gRPC server " + this.configuration.getTarget());
            this.channel = ManagedChannelBuilder.forTarget((String)this.configuration.getTarget()).usePlaintext(this.configuration.getUsePlainText().booleanValue()).build();
        } else {
            throw new IllegalArgumentException("No connection properties (host, port or target) specified");
        }
    }
}

