/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.pubsub.GooglePubsubComponent;
import org.apache.camel.component.google.pubsub.GooglePubsubConstants;
import org.apache.camel.component.google.pubsub.GooglePubsubConsumer;
import org.apache.camel.component.google.pubsub.GooglePubsubProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="google-pubsub", title="Google Pubsub", syntax="google-pubsub:projectId:destinationName", category={Category.CLOUD, Category.MESSAGING})
public class GooglePubsubEndpoint
extends DefaultEndpoint {
    private Logger log;
    @UriPath(description="Project Id")
    @Metadata(required=true)
    private String projectId;
    @UriPath(description="Destination Name")
    @Metadata(required=true)
    private String destinationName;
    @UriParam(name="loggerId", description="Logger ID to use when a match to the parent route required")
    private String loggerId;
    @UriParam(name="concurrentConsumers", description="The number of parallel streams consuming from the subscription", defaultValue="1")
    private Integer concurrentConsumers = 1;
    @UriParam(name="maxMessagesPerPoll", description="The max number of messages to receive from the server in a single API call", defaultValue="1")
    private Integer maxMessagesPerPoll = 1;
    @UriParam(name="synchronousPull", description="Synchronously pull batches of messages", defaultValue="false")
    private boolean synchronousPull;
    @UriParam(defaultValue="AUTO", enums="AUTO,NONE", description="AUTO = exchange gets ack'ed/nack'ed on completion. NONE = downstream process has to ack/nack explicitly")
    private GooglePubsubConstants.AckMode ackMode = GooglePubsubConstants.AckMode.AUTO;

    public GooglePubsubEndpoint(String uri, Component component, String remaining) {
        super(uri, component);
        if (!(component instanceof GooglePubsubComponent)) {
            throw new IllegalArgumentException("The component provided is not GooglePubsubComponent : " + component.getClass().getName());
        }
    }

    public GooglePubsubComponent getComponent() {
        return (GooglePubsubComponent)super.getComponent();
    }

    public void afterPropertiesSet() throws Exception {
        this.log = ObjectHelper.isEmpty((Object)this.loggerId) ? LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName()) : LoggerFactory.getLogger((String)this.loggerId);
        this.log.trace("Project ID: {}", (Object)this.projectId);
        this.log.trace("Destination Name: {}", (Object)this.destinationName);
    }

    public Producer createProducer() throws Exception {
        this.afterPropertiesSet();
        return new GooglePubsubProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.afterPropertiesSet();
        this.setExchangePattern(ExchangePattern.InOnly);
        GooglePubsubConsumer consumer = new GooglePubsubConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "GooglePubsubConsumer[" + this.getDestinationName() + "]", this.concurrentConsumers.intValue());
    }

    public boolean isSingleton() {
        return false;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getLoggerId() {
        return this.loggerId;
    }

    public void setLoggerId(String loggerId) {
        this.loggerId = loggerId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Integer getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Integer getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(Integer maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isSynchronousPull() {
        return this.synchronousPull;
    }

    public void setSynchronousPull(Boolean synchronousPull) {
        this.synchronousPull = synchronousPull;
    }

    public GooglePubsubConstants.AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(GooglePubsubConstants.AckMode ackMode) {
        this.ackMode = ackMode;
    }
}

