/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import com.google.api.client.util.Strings;
import com.google.api.services.pubsub.model.PublishRequest;
import com.google.api.services.pubsub.model.PublishResponse;
import com.google.api.services.pubsub.model.PubsubMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubsubProducer
extends DefaultProducer {
    public Logger logger;

    public GooglePubsubProducer(GooglePubsubEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = ((Object)((Object)this)).getClass().getName();
        }
        this.logger = LoggerFactory.getLogger((String)loggerId);
    }

    public void process(Exchange exchange) throws Exception {
        List<Exchange> entryList = GooglePubsubProducer.prepareExchangeList(exchange);
        if (entryList == null || entryList.size() == 0) {
            this.logger.warn("The incoming message is either null or empty. Triggered by an aggregation timeout?");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("uploader thread/id: " + Thread.currentThread().getId() + " / " + exchange.getExchangeId() + " . api call completed.");
        }
        this.sendMessages(entryList);
    }

    private static List<Exchange> prepareExchangeList(Exchange exchange) {
        ArrayList<Exchange> entryList = null;
        if (null == exchange.getProperty("CamelGroupedExchange")) {
            entryList = new ArrayList<Exchange>();
            entryList.add(exchange);
        } else {
            entryList = (List)exchange.getProperty("CamelGroupedExchange");
        }
        return entryList;
    }

    private void sendMessages(List<Exchange> exchanges) throws Exception {
        GooglePubsubEndpoint endpoint = (GooglePubsubEndpoint)this.getEndpoint();
        String topicName = String.format("projects/%s/topics/%s", endpoint.getProjectId(), endpoint.getDestinationName());
        ArrayList<PubsubMessage> messages = new ArrayList<PubsubMessage>();
        for (Exchange exchange : exchanges) {
            PubsubMessage message = new PubsubMessage();
            Object body = exchange.getIn().getBody();
            if (body instanceof String) {
                message.encodeData(((String)body).getBytes(StandardCharsets.UTF_8));
            } else if (body instanceof byte[]) {
                message.encodeData((byte[])body);
            } else {
                message.encodeData(GooglePubsubProducer.serialize(body));
            }
            Object attributes = exchange.getIn().getHeader("CamelGooglePubsub.Attributes");
            if (attributes != null && attributes instanceof Map && ((Map)attributes).size() > 0) {
                message.setAttributes((Map)attributes);
            }
            messages.add(message);
        }
        PublishRequest publishRequest = new PublishRequest().setMessages(messages);
        PublishResponse response = (PublishResponse)endpoint.getPubsub().projects().topics().publish(topicName, publishRequest).execute();
        List sentMessageIds = response.getMessageIds();
        int i = 0;
        for (Exchange entry : exchanges) {
            entry.getIn().setHeader("CamelGooglePubsub.MessageId", sentMessageIds.get(i));
            ++i;
        }
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(obj);
        return out.toByteArray();
    }
}

