/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GoogleDriveEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "google-drive".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(54);
        props.add("accessToken");
        props.add("apiName");
        props.add("appId");
        props.add("applicationName");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("changeId");
        props.add("channel");
        props.add("childId");
        props.add("clientFactory");
        props.add("clientId");
        props.add("clientSecret");
        props.add("commentId");
        props.add("content");
        props.add("contentChannel");
        props.add("delay");
        props.add("delegate");
        props.add("driveId");
        props.add("email");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("file");
        props.add("fileId");
        props.add("folderId");
        props.add("greedy");
        props.add("inBody");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("mediaContent");
        props.add("methodName");
        props.add("mimeType");
        props.add("modifyLabelsRequest");
        props.add("parentId");
        props.add("permissionId");
        props.add("pollStrategy");
        props.add("propertyKey");
        props.add("refreshToken");
        props.add("repeatCount");
        props.add("replyId");
        props.add("requestId");
        props.add("revisionId");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("scopes");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serviceAccountKey");
        props.add("startScheduler");
        props.add("teamDriveId");
        props.add("timeUnit");
        props.add("useFixedDelay");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("accessToken");
        secretProps.add("clientSecret");
        secretProps.add("refreshToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

