/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGoogleDriveClientFactory
implements GoogleDriveClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BatchGoogleDriveClientFactory.class);
    private NetHttpTransport transport;
    private JacksonFactory jsonFactory;

    public BatchGoogleDriveClientFactory() {
        this.transport = new NetHttpTransport();
        this.jsonFactory = new JacksonFactory();
    }

    public BatchGoogleDriveClientFactory(String proxyHost, int proxyPort) {
        try {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(proxyHost), proxyPort));
            this.transport = new NetHttpTransport.Builder().setProxy(proxy).build();
            this.jsonFactory = new JacksonFactory();
        }
        catch (UnknownHostException e) {
            LOG.error("Unknow proxy host", (Throwable)e);
        }
    }

    @Override
    public Drive makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Google Drive client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret, scopes);
            if (refreshToken != null && !"".equals(refreshToken)) {
                credential.setRefreshToken(refreshToken);
            }
            if (accessToken != null && !"".equals(accessToken)) {
                credential.setAccessToken(accessToken);
            }
            return new Drive.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Google Drive client.", (Throwable)e);
        }
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport((HttpTransport)this.transport).setClientSecrets(clientId, clientSecret).build();
    }
}

