
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.drive.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.drive.Drive.Files;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.drive.Drive$Files
 */
public enum DriveFilesApiMethod implements ApiMethod {

    COPY(
        com.google.api.services.drive.Drive.Files.Copy.class,
        "copy",
        arg("fileId", String.class),
        arg("content", com.google.api.services.drive.model.File.class)),
    DELETE(
        com.google.api.services.drive.Drive.Files.Delete.class,
        "delete",
        arg("fileId", String.class)),
    EMPTYTRASH(
        com.google.api.services.drive.Drive.Files.EmptyTrash.class,
        "emptyTrash"),
    EXPORT(
        com.google.api.services.drive.Drive.Files.Export.class,
        "export",
        arg("fileId", String.class),
        arg("mimeType", String.class)),
    GENERATEIDS(
        com.google.api.services.drive.Drive.Files.GenerateIds.class,
        "generateIds"),
    GET(
        com.google.api.services.drive.Drive.Files.Get.class,
        "get",
        arg("fileId", String.class)),
    INSERT(
        com.google.api.services.drive.Drive.Files.Insert.class,
        "insert",
        arg("content", com.google.api.services.drive.model.File.class)),
    INSERT_1(
        com.google.api.services.drive.Drive.Files.Insert.class,
        "insert",
        arg("content", com.google.api.services.drive.model.File.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),
    LIST(
        com.google.api.services.drive.Drive.Files.List.class,
        "list"),
    PATCH(
        com.google.api.services.drive.Drive.Files.Patch.class,
        "patch",
        arg("fileId", String.class),
        arg("content", com.google.api.services.drive.model.File.class)),
    TOUCH(
        com.google.api.services.drive.Drive.Files.Touch.class,
        "touch",
        arg("fileId", String.class)),
    TRASH(
        com.google.api.services.drive.Drive.Files.Trash.class,
        "trash",
        arg("fileId", String.class)),
    UNTRASH(
        com.google.api.services.drive.Drive.Files.Untrash.class,
        "untrash",
        arg("fileId", String.class)),
    UPDATE(
        com.google.api.services.drive.Drive.Files.Update.class,
        "update",
        arg("fileId", String.class),
        arg("content", com.google.api.services.drive.model.File.class)),
    UPDATE_1(
        com.google.api.services.drive.Drive.Files.Update.class,
        "update",
        arg("fileId", String.class),
        arg("content", com.google.api.services.drive.model.File.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),
    WATCH(
        com.google.api.services.drive.Drive.Files.Watch.class,
        "watch",
        arg("fileId", String.class),
        arg("contentChannel", com.google.api.services.drive.model.Channel.class));
    

    private final ApiMethod apiMethod;

    private DriveFilesApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Files.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
