/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.Drive;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveComponent;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.component.google.drive.GoogleDriveConsumer;
import org.apache.camel.component.google.drive.GoogleDriveProducer;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiCollection;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.component.google.drive.internal.GoogleDrivePropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;

@UriEndpoint(scheme="google-drive", title="Google Drive", syntax="google-drive:apiName/methodName", consumerClass=GoogleDriveConsumer.class, consumerPrefix="consumer", label="api,cloud,file")
public class GoogleDriveEndpoint
extends AbstractApiEndpoint<GoogleDriveApiName, GoogleDriveConfiguration> {
    private Object apiProxy;
    @UriParam
    private GoogleDriveConfiguration configuration;
    @UriParam
    private GoogleDriveClientFactory clientFactory;

    public GoogleDriveEndpoint(String uri, GoogleDriveComponent component, GoogleDriveApiName apiName, String methodName, GoogleDriveConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, GoogleDriveApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleDriveProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        GoogleDriveConsumer consumer = new GoogleDriveConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<GoogleDriveConfiguration> getPropertiesHelper() {
        return GoogleDrivePropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelGoogleDrive";
    }

    protected void afterConfigureProperties() {
        switch ((GoogleDriveApiName)this.apiName) {
            case DRIVE_FILES: {
                this.apiProxy = this.getClient().files();
                break;
            }
            case DRIVE_ABOUT: {
                this.apiProxy = this.getClient().about();
                break;
            }
            case DRIVE_APPS: {
                this.apiProxy = this.getClient().apps();
                break;
            }
            case DRIVE_CHANNELS: {
                this.apiProxy = this.getClient().channels();
                break;
            }
            case DRIVE_CHANGES: {
                this.apiProxy = this.getClient().changes();
                break;
            }
            case DRIVE_COMMENTS: {
                this.apiProxy = this.getClient().comments();
                break;
            }
            case DRIVE_PERMISSIONS: {
                this.apiProxy = this.getClient().permissions();
                break;
            }
            case DRIVE_PROPERTIES: {
                this.apiProxy = this.getClient().properties();
                break;
            }
            case DRIVE_REALTIME: {
                this.apiProxy = this.getClient().realtime();
                break;
            }
            case DRIVE_REPLIES: {
                this.apiProxy = this.getClient().replies();
                break;
            }
            case DRIVE_REVISIONS: {
                this.apiProxy = this.getClient().revisions();
                break;
            }
            case DRIVE_CHILDREN: {
                this.apiProxy = this.getClient().children();
                break;
            }
            case DRIVE_PARENTS: {
                this.apiProxy = this.getClient().parents();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    public Drive getClient() {
        return ((GoogleDriveComponent)this.getComponent()).getClient();
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }

    public GoogleDriveClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setClientFactory(GoogleDriveClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }
}

