/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.Drive;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.drive.BatchGoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.component.google.drive.GoogleDriveEndpoint;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiCollection;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class GoogleDriveComponent
extends AbstractApiComponent<GoogleDriveApiName, GoogleDriveConfiguration, GoogleDriveApiCollection> {
    private Drive client;
    private GoogleDriveClientFactory clientFactory;

    public GoogleDriveComponent() {
        super(GoogleDriveEndpoint.class, GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    public GoogleDriveComponent(CamelContext context) {
        super(context, GoogleDriveEndpoint.class, GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    protected GoogleDriveApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return GoogleDriveApiName.fromValue(apiNameStr);
    }

    public Drive getClient() {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(((GoogleDriveConfiguration)this.configuration).getClientId(), ((GoogleDriveConfiguration)this.configuration).getClientSecret(), ((GoogleDriveConfiguration)this.configuration).getScopes(), ((GoogleDriveConfiguration)this.configuration).getApplicationName(), ((GoogleDriveConfiguration)this.configuration).getRefreshToken(), ((GoogleDriveConfiguration)this.configuration).getAccessToken());
        }
        return this.client;
    }

    public GoogleDriveClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleDriveClientFactory();
        }
        return this.clientFactory;
    }

    public void setClientFactory(GoogleDriveClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleDriveApiName apiName, GoogleDriveConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleDriveEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

