/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GoogleBigQuerySQLConfiguration
implements Cloneable {
    @UriPath(label="common", description="BigQuery standard SQL query")
    @Metadata(required=true, supportFileReference=true, largeInput=true)
    private String queryString;
    @UriParam(description="ConnectionFactory to obtain connection to Bigquery Service. If not provided the default one will be used")
    @Metadata(autowired=true)
    private GoogleBigQueryConnectionFactory connectionFactory;
    @UriPath(label="common", description="Google Cloud Project Id")
    @Metadata(required=true)
    private String projectId;
    @UriParam(label="security", description="Service account key in json format to authenticate an application as a service account to google cloud platform")
    @Metadata(required=false)
    private String serviceAccountKey;

    public void parseRemaining(String remaining) {
        int indexOfColon = remaining.indexOf(58);
        if (indexOfColon < 0) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:query\"");
        }
        this.projectId = remaining.substring(0, indexOfColon);
        this.queryString = remaining.substring(indexOfColon + 1);
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public GoogleBigQuerySQLConfiguration setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public GoogleBigQuerySQLConfiguration setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public GoogleBigQuerySQLConfiguration setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
        return this;
    }

    public GoogleBigQuerySQLConfiguration copy() {
        try {
            return (GoogleBigQuerySQLConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

